/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/


#ifndef _KBOGGLE_H_
#define _KBOGGLE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

class KSpell;
class KToggleAction;

class Game;
class SettingsDialog;

/**
 * @short Application Main Window for KBoggle
 * @author Bram Schoenmakers <bramschoenmakers@kde.nl>
 */
class KBoggle : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    KBoggle();

    /**
     * Default Destructor
     */
    virtual ~KBoggle();

  protected slots:
    void spellOK( KSpell * );
    void spellNotOK();

    void togglePause();
    void updateTime( int );
    void updateScore( int );
    /** Shows an invalid entered word in the statusbar for a coulple of seconds. */
    void invalidWord( const QString & );
    /** Tells the user in the statusbar that the word could not be found in the grid. */
    void wordNotInGrid( const QString & );

    void gameStarted();
    void gameStopped();
    void toggleL10nBar();
    void configureKBoggle();

    /** Requests the user to start a new game if @p restart is true. */
    void configChanged( bool newgame, bool restart );

    void readSettings();
    void writeSettings();

  private:
    KAction *mPauseAction;
    KAction *mStopAction;
    KAction *mL10nBarAction;
    KSpell *mSpellChecker;
    Game *mGame;
    SettingsDialog *mSettingsDialog;

    bool mShowL10nBar;
    bool mPaused; // FIXME: This should be in mGame actually! Investigate.
};

#endif // _KBOGGLE_H_
