/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl
  
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <kapplication.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include "l10nwidget.h"
#include "cubescombo.h"

LocalisationWidget::LocalisationWidget( QWidget *parent, const char *name )
  : QWidget( parent, name )
{
  QHBoxLayout *layout = new QHBoxLayout( this );
  layout->addStretch();
  
  mLanguageLabel = new QLabel( this );
  layout->addWidget( mLanguageLabel );
  
  layout->addSpacing( 10 );
  
  layout->addWidget( new QLabel( i18n( "Cube set:" ), this ) );
  mCubesCombo = new CubesCombo( this );
  connect( mCubesCombo, SIGNAL( activated( int ) ), SLOT( cubesChanged() ) );
  layout->addWidget( mCubesCombo );
}

LocalisationWidget::~LocalisationWidget()
{
}

void LocalisationWidget::readSettings()
{
  KConfig *config = kapp->config();
  config->setGroup( "Localization" );
  mLanguageLabel->setText( i18n( "Language: %1" ).arg( KGlobal::locale()->twoAlphaToLanguageName( config->readEntry( "Dictionary", "en" ) ) ) );
  
  mCubesCombo->readSettings();
}

void LocalisationWidget::cubesChanged()
{
  // request a new game, but no KBoggle restart required
  emit configChanged( true, false );
}

#include "l10nwidget.moc"
