/*
  Copyright (C) 2005 by Bram Schoenmakers
  bramschoenmakers@kde.nl

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef L10NWIDGET_H
#define L10NWIDGET_H

class CubesCombo;

/**
  This widget shows the user which localisation options are currently set and
  makes it possible to let the user quickly switch to another language.
  @author Bram Schoenmakers <bramschoenmakers@kde.nl>
*/
class LocalisationWidget : public QWidget
{
  Q_OBJECT
  public:
    LocalisationWidget( QWidget *parent = 0, const char *name = 0 );
    ~LocalisationWidget();

    QString cubesLanguage() const { return mCubesLanguage; }

    QString wordListLanguage() const { return mLanguageLabel->text(); }

    void readSettings();

  signals:
    void configChanged( bool, bool );

  protected slots:
    /** Called when user changes mCubesCombo */
    void cubesChanged();

  private:
    QString mCubesLanguage;

    QLabel *mLanguageLabel;
    CubesCombo *mCubesCombo;
};

#endif // L10NWIDGET_H
