/***************************************************************************
                          cintro.h  -  description
                             -------------------
    begin                : mar ao 12 2003
    copyright            : (C) 2003 by Eric Coquelle
    email                : coquelle@caramail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CINTRO_H
#define CINTRO_H

#include <qdialog.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qlineedit.h>
#include <qtimer.h>
#include <qvaluelist.h>


#define MAIN_MENU           0
#define ANIM_PLAYERNAME     1
#define WAITING_PLAYERNAME  2
#define CREDITS             3

/**the welcome screen
  *@author Eric Coquelle
  */
class CCredits
{
public:
  CCredits() {};
  CCredits(int a, int b, int c, int d)
    { r=QRect(a,b,159,160); vx=c; vy=d;}
  void updatePosition()
    {
      if((r.left()+vx<0)||(r.left()+vx>535))
        vx=-vx;
      if((r.top()+vy<0)||(r.top()+vy>190))
        vy=-vy;
      r.moveBy(vx,vy);
    }
  void collision()
    { vx=-vx; vy=-vy; }
  void swap()
    { int tmp=vx; vx=vy; vy=tmp; }
    
public:
  int vx, vy;
  QRect r;
};
    
class CIntro : public QDialog  {
  Q_OBJECT
public: 
	CIntro();
	~CIntro();
  /** return user's choice */
  int getChoice();
  /** No descriptions */
  QString getPlayerName();

protected:
  void paintEvent(QPaintEvent*);
  /** Moves the ball if necessary */
  void keyPressEvent(QKeyEvent*);
  void mouseMoveEvent( QMouseEvent* );
  void mousePressEvent( QMouseEvent* );
    
protected slots: // Protected slots
  /** Updates the animation */
  void timerDone();

private:
  QPixmap background;
  QPixmap playernamebg;
  QValueList<QPixmap> credits;
  QValueList<CCredits> creditpos;
  QImage ball;
  QLineEdit *playername;
  QTimer *timer;
  int choice;
  int dy;
  int ymin;
  float ballscale;
  float shiftballscale;
  int choicemax;
  int creditmax;
  int operation;
  int yanimplayername;
};

#endif
