/*
 * puz_app.cpp -- Copyright (C) 1998 by M. G"otze
								Copyright (c) 2001 by Eric Coquelle
 */

#include <stdio.h>

#include <kfiledialog.h>
#include <kmessagebox.h>

#include "icons.h"
#include "cpreferences.h"
#include "puz_app.h"
#include "puzzle.h"
#include "cintro.h"


KSlideApp::KSlideApp()
  : puzzle(0)
{
  int choice;
  QString playername;
	KIconLoader icone;
	setIcon(icone.loadIcon("kslide",KIcon::Small));

  CIntro intro;
  intro.exec();
  choice=intro.getChoice();
  
  puzzle = new KSlidePuzzle(this, 0 );
  prefs=new CPreferences(this);
  statusbar=new KStatusBar(this);
  statusbar->insertItem(i18n("Ready"),2);
  statusbar->insertItem(i18n("No time limit"),3);
  statusbar->setItemAlignment(2,KStatusBar::AlignRight);
  puzzle->setStatusBar(statusbar);


  initActions();

  connect(puzzle, SIGNAL(sigStartedScrambling()), this,
    SLOT(scramblingStarted()));
  connect(puzzle, SIGNAL(sigStoppedScrambling()), this,
    SLOT(scramblingStopped()));
  connect(puzzle, SIGNAL(sigStartedOrdering()), this,
    SLOT(orderingStarted()));
  connect(puzzle, SIGNAL(sigStoppedOrdering()), this,
    SLOT(orderingStopped()));
  connect(puzzle, SIGNAL(sigPuzzleSolved()), this, SLOT(orderingStopped()));
  connect(puzzle, SIGNAL(toggleHint(bool)), this, SLOT(slotEnableMenuHint(bool)));
  connect(puzzle, SIGNAL(enableMenus(bool)), this, SLOT(slotMenusEnabled(bool)));

  setModeCl4();
  puzzle->show();
  resize(565,565+statusbar->height());
  switch(choice)
  {
    case 0:
      playername=intro.getPlayerName();
      if(playername.isEmpty())
        playername=i18n("No name");
      puzzle->setPlayername(playername);
      break;
    case 1:
      puzzle->slotLoadGame();
      break;
    case 2:
      puzzle->slotViewHallOfFame();
      break;
    case 3:
      break;
    case 4:
    default:
      close();
      break;
  }

  KConfig *config = kapp->config();
  config->setGroup("Player");
  config->writeEntry("playername",playername);
}

KSlideApp::~KSlideApp()
{
  delete puzzle;
  delete prefs;
}

void KSlideApp::setMode(unsigned char mode)
{
	int i;
	if(mode==9)
	{
		if (!puzzle->loadImage(tOpt(1)))
    		return;
  }
  else if (!puzzle->loadImage(tOpt(mode)))
   return;
  if(mode<4)
  {
    for(i=0;i<4;i++)
      menu[i]->setChecked(false);
    menu[mode]->setChecked(true);
  }
  else
  {
    for(i=0;i<6;i++)
    menushape[i]->setChecked(false);
    menushape[mode-4]->setChecked(true);
  }
}

void KSlideApp::setModeCl3() { setMode(0); }
void KSlideApp::setModeCl4() { setMode(1); }
void KSlideApp::setModeCl5() { setMode(2); }
void KSlideApp::setModeCl6() { setMode(3); }
void KSlideApp::setModeCo()  { setMode(4); }
void KSlideApp::setModeCr()  { setMode(5); }
void KSlideApp::setModeDi()  { setMode(6); }
void KSlideApp::setModeIs()  { setMode(7); }
void KSlideApp::setModeTr()  { setMode(8); }
void KSlideApp::setModeNo()  { setMode(9); }

void KSlideApp::scramblingStarted()
{
  enableModeChange(FALSE);
}

void KSlideApp::scramblingStopped()
{
  enableModeChange(TRUE);
}

void KSlideApp::orderingStarted()
{
  enableModeChange(FALSE);
}

void KSlideApp::orderingStopped()
{
  enableModeChange(TRUE);
}

void KSlideApp::toggleSound()
{
}

void KSlideApp::toggleMissingTile()
{
}

void KSlideApp::help()
{
  kapp->invokeHTMLHelp("", "");
}

void KSlideApp::enableModeChange(const bool enable)
{
}

void KSlideApp::defaultImage()
{
  if (!puzzle->isIdle())
    return;
  puzzle->loadImage(moKeepMode | moLoadDefImage);
}

void KSlideApp::loadImage()
{
  if (!puzzle->isIdle())
    return;
  QString s = KFileDialog::getOpenFileName(0, "*.jpg | jpg images\n*.png | png images", this,
    i18n("Load Image..."));
  if (!s.length())
    return;
  if (!puzzle->loadImage(moKeepMode, s.data()))
    KMessageBox::information(this,  i18n(
      "An error occurred while trying to load the image.\n"
      "Please check whether the image is of a valid type\n"
      "and has a suitable size. See the help for more\n"
      "information on this."), i18n("Oops...") );
}

void KSlideApp::initActions() {
  menu=new KToggleAction* [4];
  menushape=new KToggleAction* [6];

    new KAction( i18n("Scramble puzzle"), "run", 0, puzzle, SLOT(scramble()), actionCollection(),"game_scramble");
    solve=new KAction( i18n("Solve puzzle"), "solve", 0, puzzle, SLOT(order()), actionCollection(),"game_solve");
    new KAction( i18n("View hiscores"), "run", 0, puzzle, SLOT(slotViewHallOfFame()), actionCollection(),"game_hiscores");		
    new KAction( i18n("Load game"),"fileopen", 0, puzzle, SLOT(slotLoadGame()), actionCollection(),"puzzle_load");
    save=new KAction( i18n("Save game"), "filesave",0, puzzle, SLOT(slotSaveGame()), actionCollection(),"puzzle_save");
    new KAction( i18n("Quit"), "exit",0, this, SLOT(close()), actionCollection(),"game_quit");
      menu[0]=new KToggleAction( i18n("Tiny"), 0, this, SLOT(setModeCl3()), actionCollection(),"size_tiny");
      menu[1]=new KToggleAction( i18n("Normal"), 0, this, SLOT(setModeCl4()), actionCollection(),"size_normal");
      menu[2]=new KToggleAction( i18n("Large"), 0, this, SLOT(setModeCl5()), actionCollection(),"size_large");
      menu[3]=new KToggleAction( i18n("Giant"), 0, this, SLOT(setModeCl6()), actionCollection(),"size_giant");
      menushape[0]=new KToggleAction( i18n("Cross"), 0, this, SLOT(setModeCr()), actionCollection(),"block_cross");
      menushape[1]=new KToggleAction( i18n("Corners"), 0, this, SLOT(setModeCo()), actionCollection(),"block_corners");
      menushape[2]=new KToggleAction( i18n("Diamond"), 0, this, SLOT(setModeDi()), actionCollection(),"block_diamond");
      menushape[3]=new KToggleAction( i18n("Triangle"), 0, this, SLOT(setModeTr()), actionCollection(),"block_triangle");
      menushape[4]=new KToggleAction( i18n("Isles"), 0, this, SLOT(setModeIs()), actionCollection(),"block_isles");
      menushape[5]=new KToggleAction( i18n("Normal"), 0, this, SLOT(setModeNo()), actionCollection(),"block_normal");
/*        new KAction( i18n("Load image"), 0, this, SLOT(loadImage()), actionCollection(),"load_image");
        new KAction( i18n("Default image"), 0, this, SLOT(defaultImage()), actionCollection(),"default_image");
        new KAction( i18n("Random image"), 0, this, SLOT(toggleMissingTile()), actionCollection(),"random_file");*/
        new KAction( i18n("Use sound"), 0, this, SLOT(toggleSound()), actionCollection(),"sound");
        hint=new KAction( i18n("Give hint"), 0, puzzle, SLOT(slotGiveHint()), actionCollection(),"hint");
        stophint=new KAction( i18n("Stop hint"), 0, puzzle, SLOT(slotStopHint()), actionCollection(),"stop_hint");
        new KAction( i18n("Preferences"),"configure", 0, this, SLOT(slotPreferences()), actionCollection(),"preferences");

        createGUI();
        slotMenusEnabled(false);
}


/** Display the configuration window */
void KSlideApp::slotPreferences(){
//	CPreferences prefs;
	QString s;
  QString basename;
  QString name;
	int moves;
	int gametime;
	int hintnumber;

	if(prefs->exec())
	{
		if(prefs->getMaxMovesNumber( &moves))
			puzzle->setMaxMoves( moves );
		else
			puzzle->setMaxMoves( -1 );

		if(prefs->getMaxSolveTime( &gametime))
			puzzle->setMaxGameTime( gametime );
		else
			puzzle->setMaxGameTime( -1 );
			
		if(prefs->getMaxHintNumber( &hintnumber))
			puzzle->setMaxHints( hintnumber );
		else
			puzzle->setMaxHints( -1 );
			
		puzzle->setGameLevel(prefs->getGameLevel());

    basename=KGlobal::dirs()->findResourceDir("data","kslide/kslideui.rc");
    basename+="kslide/pics/";
    name=basename+name.sprintf("frame%i.png",prefs->getTextureNumber());
    puzzle->setFrameImage(name);
    name=basename+name.sprintf("tile%i.png",prefs->getTextureNumber());
    puzzle->setTiledImage(name);

    s=prefs->getLoadImageName();

//   			 puzzle->setMask(0);
		
		if((s.length() != 0) && (!puzzle->loadImage(moKeepMode, s.data())))
		{
		    KMessageBox::information(this,  i18n(
   		   	"An error occurred while trying to load the image.\n"
	      "Please check whether the image is of a valid type\n"
   	   		"and has a suitable size. See the help for more\n"
	   	   "information on this."), i18n("Oops...") );
   			 puzzle->setMask(1);
   		}
	}
}

/** No descriptions */
void KSlideApp::slotEnableMenuHint(bool b){
  hint->setEnabled(b);
  stophint->setEnabled(!b);
}

/** Enable or not the menus */
void KSlideApp::slotMenusEnabled(bool b){
  int i;
  hint->setEnabled(b);
  stophint->setEnabled(false);
  solve->setEnabled(b);
  save->setEnabled(b);
  for(i=0;i<4;i++)
    menu[i]->setEnabled(!b);
  for(i=0;i<6;i++)
    menushape[i]->setEnabled(!b);
}

//#include "puz_app.moc.cpp"
