/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CELLSTATE_H
#define CELLSTATE_H

#include "possiblevalues.h"

// Forward declarations
class QDomDocument;
class QDomElement;
class PartState;

/**
 * @brief holds the state of a cell
 */
class CellState
{
public:
    /// The type of the cell
    enum CellType { NORMAL, FIXED, GENERATED } type;

    PossibleValues userPossible;
    PartState *box;
    PartState *col;
    PartState *row;

    /// Default Constructor
    CellState();

    /// Assignment operator
    const CellState& operator=( const CellState &grid );

    /// Clears the cell
    void clear();

    /**
     * Sets the cells value
     * @return True if the cell could be set to this value
     */
    bool setValue( int val );

    /// Returns the value of a cell
    int value() const { return m_value; }

    /// Returns a list of possible values
    PossibleValues possible();

    /// Returns true if this value is possible in this cell
    bool isPossible( int val );

    /// Returns true if any values are possible
    bool anyPossible();

    /// Makes the user possiblities match the real possiblities
    void matchPossible();

    /**
     * Saves a cell
     * @param doc The document where saving to
     * @return The Element created
     */
    QDomElement saveCell( QDomDocument &doc, int position );

    /**
     * Loads a cell
     * @param e The element to load this cell from
     * @param version THe version of the file where loading
     * @return True if successful
     */
    bool loadCell( QDomElement &e, float version );

    /// Tells the cell that a part it belongs to has changed
    void partChanged();

private:
    int m_value;
    PossibleValues m_poss;
};

#endif
