/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GENERATOR_H
#define GENERATOR_H

#include <list>
#include "gridstate.h"

// Forward Declaration
class KProgressDialog;

/**
 * Generates grids of various difficulty levels
*/
class Generator
{
public:
    /**
        * Constructor
        * @param difficulty How hard to make the level
        */
    Generator( int difficulty );

    /**
     * Generates a new GridState to match the difficulty
     * @param progress The progress dialog to use
     */
    GridState generate( KProgressDialog *progress );

private:
    struct Solution
    {
        GridState grid;
        int mnrDiff;
        int mjrDiff;

        bool operator<( const Solution &sol ) const;
    };

    GridState generateFresh();

    bool step( const GridState &parent, std::list<int> removed, KProgressDialog *progress );

    bool contains( std::list<int> &list, const int val ) const;

    std::list<Solution> m_solutions;

    int m_diff;
};

#endif
