/***************************************************************************
 *   Copyright (C) 2005 by Leon Pennington                                 *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "gridcell.h"
#include "gridview.h"
#include "cellstate.h"

#include <qpainter.h>

GridCell::GridCell(QCanvas *canvas, int position ) : QCanvasRectangle( canvas )
{
    m_possibles.clear();
    m_value = -1;
    m_pos = position;
    m_type = NORMAL;
    m_active = false;

    setBrush( QBrush( Qt::white ));
    setPen( QPen( Qt::black ));
    m_fontPen = QPen( Qt::black );
}

void GridCell::setCell( CellState state )
{
    setType( (CellType)state.type );
    m_value = state.value();
    m_possibles = state.userPossible;
}

void GridCell::setActive( bool active )
{
    m_active = active;
    setType( m_type );
}

void GridCell::setAllPossibles( PossibleValues possibles )
{
    m_possibles = possibles;
}

void GridCell::clear()
{
    m_value = -1;
    m_possibles.clear();
    setType( NORMAL );
}

void GridCell::resize( int xOffset, int yOffset, int width, int height, const QFont &font )
{
    int col = m_pos % 9;
    int row = m_pos / 9;
    setX( xOffset + ( col * width ) + (( col / 3 ) * 2 ));
    setY( yOffset + ( row * height ) + (( row / 3 ) * 2 ));
    setSize( width, height );
    m_font = font;
}

void GridCell::drawShape( QPainter &p )
{
    p.fillRect( rect(), brush() );
    p.drawRect( rect() );
    if( m_value >= 0 )
    {
        p.setPen( m_fontPen );
        p.setFont( m_font );
        p.drawText( rect(), Qt::AlignHCenter|Qt::AlignVCenter, QString::number( m_value + 1 ));
    }
    else if( !m_possibles.isEmpty() )
    {
        QFont font = m_font;
        font.setPixelSize( m_font.pixelSize() / 5 );
        p.setPen( QPen( Qt::gray ) );
        p.setFont( font );
        p.drawText( rect(), Qt::AlignHCenter|Qt::AlignTop|Qt::BreakAnywhere, m_possibles.toString() );
    }
}

void GridCell::setType( CellType type )
{
    m_type = type;
    if( m_active )
    {
        setPen( QPen( Qt::green ));
        switch( type )
        {
            case NORMAL:
                setBrush( QBrush( QColor( 200, 255, 200 ) ));
                m_fontPen = QPen( Qt::black );
                break;
            case FIXED:
                setBrush( QBrush( QColor( 200, 220, 200 )));
                m_fontPen = QPen( Qt::white );
                break;
            case GENERATED:
                setBrush( QBrush( QColor( 200, 255, 200 ) ));
                m_fontPen = QPen( Qt::blue );
                break;
        }
    }
    else
    {
        setPen( QPen( Qt::black ));
        switch( type )
        {
            case NORMAL:
                setBrush( QBrush(Qt::white ));
                m_fontPen = QPen( Qt::black );
                break;
            case FIXED:
                setBrush( QBrush( QColor( 200, 200, 200 )));
                m_fontPen = QPen( Qt::white );
                break;
            case GENERATED:
                setBrush( QBrush(Qt::white ));
                m_fontPen = QPen( Qt::blue );
                break;
        }
    }
}




