/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GRIDCELL_H
#define GRIDCELL_H

#include "possiblevalues.h"

#include <qcanvas.h>

//Forward declarations
class QFont;
class CellState;

/**
 * @brief draws a single cell in the application
 */
class GridCell : public QCanvasRectangle
{
public:
    enum CellType { NORMAL, FIXED, GENERATED };

    /// Default Constructor
    GridCell(QCanvas *canvas, int position );

    /// Sets the cell to match the cellstate
    void setCell( CellState state );

    /// Is this cell the current active cell
    bool active() const { return m_active; }
    /// Sets wheter this cell is the current active cell
    void setActive( bool active );

    /// Sets the possible values
    void setAllPossibles( PossibleValues possibles );

    /// Clears the cell
    void clear();

    /// The type of cell
    CellType type() const { return m_type; }

    /// The cells position in the standard array
    int pos() const { return m_pos; }
    /// Resizes the cell
    void resize( int xOffset, int yOffset, int width, int height, const QFont &font );

    /// Draws the cell
    void drawShape( QPainter &p );

private:
    void setType( CellType type );

    CellType m_type;
    bool m_active;
    int m_pos;
    int m_value;
    PossibleValues m_possibles;
    QPen m_fontPen;
    QFont m_font;
};

#endif
