/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef GRIDVIEW_H
#define GRIDVIEW_H

#include <qcanvas.h>

// Forward declarations
class PossibleValues;
class GridState;
class CellState;
class GridCell;

/**
 * @brief the main view widget
 */
class GridView : public QCanvasView
{
Q_OBJECT
public:
    /// The movement between cells
    enum GridMovement{ UP, DOWN, LEFT, RIGHT };

    /// Default Constructor
    GridView(QWidget *parent = 0, const char *name = 0);

    void setGrid( const GridState &grid );

    /// Sets the current cell
    void setCurrentCell( CellState state );
    /// Returns the current selected cell
    int currentCell() const { return m_activeCell; }

    /// Sets a cell to match a CellState
    void setCell( int cell, CellState state );
    /// Sets all the possible values for a cell
    void setCellAllPossibles( int cell, PossibleValues possible );
    /// Clears the grid
    void clear();

    /**
     * Draws the grid on the given QPainter for printing
     * @param painter The painter
     * @param area The area to do the drawing to
     */
    void print( QPainter &painter, QRect area );

    /// Moves the current cell marker in the direction specified
    void moveCurrentCell( int move, bool force );

protected:
    ///
    void mouseMoveEvent( QMouseEvent *e );
    ///
    void viewportResizeEvent( QResizeEvent* );

private:
    int m_activeCell;
    GridCell *m_pCells[81];
};

#endif
