/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KUDUS_H_
#define _KUDUS_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>
#include <gridstate.h>

//forward declarations
class QFont;
class ViewGrid;
class GridView;
class KToggleAction;

/**
 * @short Application Main Window
 */
class Kudus : public KMainWindow
{
   Q_OBJECT
public:
   /// Default Constructor
   Kudus();

protected slots:
   /// called when a new game is requested
   void gameNew();
   /// Restarts the current game
   void gameRestart();
   /// Loads a previously save game
   void gameLoad();
   /// Saves the current game always asks for filename
   void gameSave();
   /// Clears the grid
   void gameClear();
   /// Switches the game to design mode
   void gameDesign();
   /// Prints off the current grid
   void gamePrint();

   /// Solves the current suduko if possible
   void moveSolve();
   /// penicl in the possibilities to the unfilled cells
   void movePencil();
   /// Gives a hint in the current suduko
   void moveHint();
   /// Moves the current cell
   void moveCell( int move );
   /// Clears the current cell
   void moveClearCell();

   /// Sets a cells value
   void setValue( int value );
   /// Toggles a possible value
   void togglePossible( int value );

protected:
   ///
   bool queryClose();

private slots:
   /// Called when the toolbar needs configuring
   void optionsConfigureToolbars();
   /// Called to apply new configuration for toolbars
   void applyNewToolbarConfig();

private:
   /// Sets up the window
   void setupWindow();
   /// sets up the action for menus and toolbars
   void setupActions();
   /// Sets the windows title image
   void showTitle( int mjrDiff, int mnrDiff, const QString &type );
   /// Sets the current grid and the view
   void startGrid( bool fullstate = false );
   /// Check to see if the game is complete
   void checkComplete();
   /// Generates a grid and prints it
   bool genPrintGrid( QPainter &painter, QRect rect, int difficulty );

   enum GameType { NONE, DESIGN, SIMPLE } m_gameType;
   GridView *m_pView;
   KToggleAction *m_pDesign;
   bool m_modified;
   bool m_solveActive;
   GridState m_currentGrid;
   GridState m_startGrid;
};

#endif // _KUDUS_H_
