/***************************************************************************
 *   Copyright (C) 2005 by Leon Pennington                                 *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "newdialog.h"

#include <qlayout.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>

#include <klocale.h>

NewDialog::NewDialog( QWidget *parent, bool useCurrent )
        : KDialogBase( parent, 0, true, i18n( "New Game" ), KDialogBase::Ok|KDialogBase::Cancel )
{
    QWidget *main = new QWidget( this );
    setMainWidget( main );

    QVBoxLayout *vb = new QVBoxLayout( main, 0, spacingHint() );

    if ( useCurrent )
    {
        m_pUseCurrent = new QCheckBox( i18n( "use current designed grid", "Use Current Grid" ), main );
        m_pUseCurrent->setChecked( true );
        vb->addWidget( m_pUseCurrent );
        connect( m_pUseCurrent, SIGNAL( toggled( bool ) ), SLOT( slotUseCurrent( bool ) ) );
    }
    else
        m_pUseCurrent = 0;

    QHBoxLayout *hl = new QHBoxLayout( vb );
    hl->addWidget( new QLabel( i18n( "Difficulty level", "Difficulty" ), main ) );
    m_pDifficulty = new QComboBox( main );
    m_pDifficulty->insertItem( i18n( "easy level", "My brain hurts!" ) );
    m_pDifficulty->insertItem( i18n( "moderate level", "I can do logic me." ) );
    m_pDifficulty->insertItem( i18n( "hard level", "Smarter than the average mammal." ) );
    m_pDifficulty->insertItem( i18n( "very hard level", "I'm part Vulcan." ) );
    m_pDifficulty->insertItem( i18n( "extreme level", "Here I am a brain the size of a planet..." ) );
    hl->addWidget( m_pDifficulty );

    if( useCurrent )
        m_pDifficulty->setEnabled( false );
}

int NewDialog::difficulty() const
{
    if( m_pUseCurrent && m_pUseCurrent->isChecked() )
        return -1;
    else
        return m_pDifficulty->currentItem();
}

void NewDialog::slotUseCurrent( bool on )
{
    m_pDifficulty->setEnabled( !on );
}

#include "newdialog.moc"
