/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "partstate.h"

#include "cellstate.h"

PartState::PartState()
{
    for ( int i = 0; i < 9; ++i )
        cells[i] = 0;
}

void PartState::addCell( CellState *cell )
{
    for ( int i = 0; i < 9; ++i )
    {
        if ( !cells[i] )
        {
            cells[i] = cell;
            return;
        }
    }
}

bool PartState::used( int val ) const
{
    for ( int i = 0; i < 9; ++i )
    {
        if ( cells[i]->value() == val )
            return true;
    }

    return false;
}

bool PartState::check()
{
    bool changed = false;

    for ( int num = 0; num < 9; ++num )
    {
        if ( !used( num ) )
        {
            CellState *fCell = 0;
            int poss = 0;

            for ( int cell = 0; cell < 9; ++cell )
            {
                if ( cells[cell]->isPossible( num ) )
                {
                    fCell = cells[cell];
                    ++poss;
                }

                if ( poss > 1 )
                    break;
            }

            if ( poss == 1 )
            {
                fCell->setValue( num );
                changed = true;
            }
        }
    }

    return changed;
}

void PartState::valueChanged()
{
    for( int i = 0; i < 9; ++i )
        cells[i]->partChanged();
}
