/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PARTSTATE_H
#define PARTSTATE_H

// Forward delcarations
class CellState;

/**
 * @brief Holds the details of grid parts
 */
class PartState
{
public:
    CellState *cells[9];

    /// Default Constructor
    PartState();

        /// Adds a cell to the part
    void addCell( CellState *cell );

        /// Returns if this value has been used in this part
    bool used( int val ) const;

    /**
     * Checks the part for fillable cells
     * @return True if it found one or more cells til fill
     */
    bool check();

    /// Tells cells in the part that a value has changed
    void valueChanged();
};

#endif
