/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "possiblevalues.h"

#include <qstring.h>

PossibleValues::PossibleValues()
{
    clear();
}

void PossibleValues::clear()
{
    for( int i = 0; i < 9; ++i )
        m_poss[i] = false;
}

bool PossibleValues::isEmpty() const
{
    for( int i = 0; i < 9; ++i )
    {
        if( m_poss[i] )
            return false;
    }

    return true;
}

bool PossibleValues::isSingle() const
{
    bool found = false;
    for( int i = 0; i < 9; ++i )
    {
        if( m_poss[i] )
        {
            if( found )
                return false;
            else
                found = true;
        }
    }

    return found;
}

int PossibleValues::first() const
{
    for( int i = 0; i < 9; ++i )
    {
        if( m_poss[i] )
            return i;
    }

    return -1;
}

QString PossibleValues::toString() const
{
    QString rst = "";
    for( int i = 0; i < 9; ++i )
    {
        if( m_poss[i] )
            rst += QString::number( i + 1 );
    }

    return rst;
}
