/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POSSIBLEVALUES_H
#define POSSIBLEVALUES_H

class QString;

/**
 * @brief Holds possible values for a cell
 */
class PossibleValues{
public:
    /// Default constructor
    PossibleValues();

    /// Clears all the possibles
    void clear();

    /// True if theirs no possible values
    bool isEmpty() const;

    /// True of their is only one possible value
    bool isSingle() const;

    /// Returns the first possible value
    int first() const;

    /// Returns a string representing the values
    QString toString() const;

    /// Indexing for retirving setting possibles
    const bool operator[]( const int idx ) const { return m_poss[idx]; }
    bool& operator[]( const int idx ) { return m_poss[idx]; }
private:
    bool m_poss[9];
};

#endif
