/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "printdialog.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qcombobox.h>

#include <klocale.h>

PrintDialog::PrintDialog(QWidget *parent, bool haveGrid )
    : KDialogBase( parent, 0, true, i18n( "Printing Options" ), KDialogBase::Ok|KDialogBase::Cancel )
{
    setupDialog();
    m_pCurrent->setChecked( haveGrid );
    m_pNumGrids->setEnabled( !haveGrid );
    m_pDifficulty->setEnabled( !haveGrid );
}

bool PrintDialog::currentGrid() const
{
    return m_pCurrent->isChecked();
}

int PrintDialog::numberGrids() const
{
    int rst = 0;
    switch( m_pNumGrids->currentItem() )
    {
        case 0: rst = 1; break;
        case 1: rst = 2; break;
        case 2: rst = 4; break;
    }

    return rst;
}

int PrintDialog::difficutyLevel() const
{
    return m_pDifficulty->currentItem();
}

void PrintDialog::slotCurrentToggled( bool on )
{
    m_pNumGrids->setEnabled( !on );
    m_pDifficulty->setEnabled( !on );
}

void PrintDialog::setupDialog()
{
    QWidget *main = new QWidget( this );
    setMainWidget( main );

    QGridLayout *gl = new QGridLayout( main, 3, 3, 0, spacingHint() );
    m_pCurrent = new QCheckBox( i18n( "Will we use the current grid to print?", "Use Current Grid" ), main );
    gl->addMultiCellWidget( m_pCurrent, 0, 0, 0, 2, Qt::AlignHCenter );
    m_pNumGrids = new QComboBox( main );
    m_pNumGrids->insertItem( i18n( "1 New Grid To Generate For Print", "%1" ).arg( 1 ) );
    m_pNumGrids->insertItem( i18n( "2 New Grid To Generate For Print", "%1" ).arg( 2 ) );
    m_pNumGrids->insertItem( i18n( "4 New Grid To Generate For Print", "%1" ).arg( 4 ) );
    gl->addWidget( m_pNumGrids, 1, 1 );
    gl->addWidget( new QLabel( m_pNumGrids, i18n( "Number of grids" ), main ), 1, 0, Qt::AlignRight );
    m_pDifficulty = new QComboBox( main );
    m_pDifficulty->insertItem( i18n( "easy level", "My brain hurts!" ) );
    m_pDifficulty->insertItem( i18n( "moderate level", "I can do logic me." ) );
    m_pDifficulty->insertItem( i18n( "hard level", "Smarter than the average mammal." ) );
    m_pDifficulty->insertItem( i18n( "very hard level", "I'm part Vulcan." ) );
    m_pDifficulty->insertItem( i18n( "extreme level", "Here I am a brain the size of a planet..." ) );
    gl->addMultiCellWidget( m_pDifficulty, 2, 2, 1, 2 );
    gl->addWidget( new QLabel( m_pNumGrids, i18n( "Difficulty level" ), main ), 2, 0, Qt::AlignRight );

    connect( m_pCurrent, SIGNAL(toggled( bool )), SLOT(slotCurrentToggled(bool)));
}

#include "printdialog.moc"
