/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef PRINTDIALOG_H
#define PRINTDIALOG_H

#include <kdialogbase.h>

//Forward declarations
class QCheckBox;
class QComboBox;

/**
 * @brief The dialog for controlling prints
 */
class PrintDialog : public KDialogBase
{
Q_OBJECT
public:
    /// Default Constructor
    PrintDialog(QWidget *parent = 0, bool haveGrid = false );

    /// Whether to use the current grid
    bool currentGrid() const;
    /// How many grids to generate
    int numberGrids() const;
    /// What difficuty to generate to
    int difficutyLevel() const;

protected slots:
    /// called when the current checkbox has been toggled
    void slotCurrentToggled( bool on );

private:
    void setupDialog();
    QCheckBox *m_pCurrent;
    QComboBox *m_pNumGrids;
    QComboBox *m_pDifficulty;
};

#endif
