/***************************************************************************
 *   Copyright (C) 2005 by Leon Pennington                                 *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "solver.h"
#include "gridstate.h"
#include "possiblevalues.h"

#include <list>

Solver::Solver( GridState grid )
{
    m_grid = grid;
    m_mnrDiff = m_grid.simpleSolve();
    m_pFirst = m_pFinal = 0;
    m_mjrDiff = 0;
}

Solver::~ Solver()
{
    delete m_pFirst;
    delete m_pFinal;
}

bool Solver::findSolution()
{
    delete m_pFirst;
    delete m_pFinal;
    m_pFirst = m_pFinal = 0;

    if ( m_grid.complete() )
    {
        m_pFinal = new GridState( m_grid );
        return true;
    }
    else if ( !step( m_grid, m_mnrDiff ) )
    {
        if ( m_pFirst )
        {
            m_pFinal = new GridState( *m_pFirst );
            return true;
        }
    }

    return false;
}

GridState Solver::firstSolution() const
{
    if ( m_pFirst )
        return *m_pFirst;
    else
    {
        GridState grid;
        return grid;
    }
}

GridState Solver::solution() const
{
    if ( m_pFinal )
        return *m_pFinal;
    else
    {
        GridState grid;
        return grid;
    }
}

bool Solver::step( GridState grid, int mnrDiff )
{
    if ( grid.complete() )
    {
        if ( m_pFirst && *m_pFirst != grid )
        {
            m_mnrDiff = mnrDiff;
            return true;
        }
        else
        {
            m_pFirst = new GridState( grid );
            m_mnrDiff = mnrDiff;
            return false;
        }
    }

    ++m_mjrDiff;

    for ( int i = 0; i < 81; ++i )
    {
        if ( grid.value( i ) < 0 )
        {
            PossibleValues poss = grid.possible( i );

            for ( int j = 0; j < 9; ++j )
            {
                if ( poss[j] )
                {
                    GridState nGrid = grid;
                    nGrid.setValue( i, j );
                    int diff = mnrDiff + nGrid.simpleSolve();

                    if ( nGrid.possible() )
                    {
                        if ( step( nGrid, diff ) )
                            return true;
                    }
                }
            }

            break;
        }
    }

    return false;
}
