/***************************************************************************
 *   Copyright (C) 2005-2007 by Leon Pennington                            *
 *   leon@leonscape.co.uk                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOLVER_H
#define SOLVER_H

#include "gridstate.h"

/**
 * This class solves Suduko grids
*/
class Solver{
public:
   /**
    * Constructor
    * @param grid The grid this solver will try to solve
    */
   Solver( GridState grid );
   /// Destructor
   ~Solver();

   /**
    * Tries to find a solution to the given gridstate
    * @return True if it found a solution
    */
   bool findSolution();

   /// Returns the first solution found
   GridState firstSolution() const;

   /// Returns the found solution
   GridState solution() const;

   /// Returns the minor difficulty
   int minorDifficulty() const { return m_mnrDiff; }
   /// Returns the major difficulty
   int majorDifficulty() const { return m_mjrDiff; }

private:
   /// Performs a step in the solution
   bool step( GridState grid, int difficulty );

   GridState m_grid;
   GridState *m_pFinal;
   GridState *m_pFirst;
   int m_mnrDiff;
   int m_mjrDiff;
};

#endif
