/***************************************************************************
                          commongraph.h  -  description
                             -------------------
    begin                : Sat Oct 19 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#ifndef COMMONGRAPH_H
#define COMMONGRAPH_H

#ifdef KDE_APP
class KPrinter;
#else
class QPrinter;
#endif //KDE_APP

class QColor;
class QString;

/**
 * \author Fungmeista
 * \brief An abstract class of which both 3-D and 2-D graphs are a member of.  It contains abstract
 *  functions which both 3-D and 2-D graphs implement in their own way such as toggling the grid and
 *  calculating distance.  Interface.ui.h casts all graphs into this base class so that both 3-D and
 *  2-D graphs can be treated alike.
 */

class CommonGraph
{
	public:
		CommonGraph(){}       
		virtual ~CommonGraph(){}

		//coordinate style
		static const int RECTANGULAR = 0;
		static const int POLAR = 1;

		static const enum{
			FUNCTIONGRAPH = 0,
			POLARGRAPH,
			PARAMETRICGRAPH,
			STATGRAPH,
			DENSITYPLOT
                	#ifdef GLGRAPH
			,GLFUNCTIONGRAPH,
			GLPOLARGRAPH,
			GLCYLINDRICALGRAPH,
			GLPARAMETRICGRAPH
			#endif //GLGRAPH
		} graphType;

		virtual int execMathFunction( const char * ){return -1;}

		virtual bool isTracing() const{return false;}
		virtual void setSnapToGrid(bool){}
		virtual bool isSnapToGrid() const{return false;}

		virtual int getAngle() const{return -1;}
		virtual void setAngle(int){}
		virtual int getGraphType() const = 0;

		/** Prints graph as is.  A printer setup dialog will be opened. */
		#ifdef KDE_APP
		virtual void print(KPrinter *) = 0;
		#else
		virtual void print(QPrinter *) = 0;
		#endif //KDE_APP

		/** Saves the graph as an image.
		  * \param filename Path plus the complete name of the image file to save to.
		  *        This should include the suffix of the file name if one is desired. 
		  * \param suffix This specifies what type of image format export the graph as.
		  *        This should be the standard file suffix of the desired image format (png, jpg, bmp, etc.).
		  *
		  */
		virtual void exportAsImage(const QString &, const QString &) = 0;

		virtual bool getAxisState() const = 0;
		virtual bool getGridState() const = 0;
		virtual bool getScaleState() const = 0;

		virtual void zoomStat(){}
		virtual void zoomIn() = 0;
		virtual void zoomOut() = 0;
		virtual void zoomStd() = 0;
		virtual void zoomBox(){}

		virtual QColor axisColor() const = 0;
		virtual QColor gridColor() const = 0;
		virtual QColor backgroundColor() const = 0;
		virtual QColor scaleColor() const = 0;

		virtual void setAxis(bool) = 0;
		virtual void setGrid(bool) = 0;
		virtual void setScale(bool) = 0;
		virtual void setTrace(bool) = 0;

		virtual void setDrawConnected(bool){}
		virtual bool isDrawConnected() const{return false;}

		virtual void setAxisColor(const QColor &) = 0;
		virtual void setGridColor(const QColor &) = 0;
		virtual void setBackgroundColor(const QColor &) = 0;
		virtual void setScaleColor(const QColor &) = 0;

		virtual int getXZoomFactor() const = 0;
		virtual int getYZoomFactor() const = 0;
		virtual void setXZoomFactor(int) = 0;
		virtual void setYZoomFactor(int) = 0;
};

#endif

