/***************************************************************************
                          expression.h  -  simple class to hold a few parameters for an expression
                             -------------------
    begin                : Wed Oct 9 2002
    copyright            : (C) 2002-2003 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EXPRESSION_H
#define EXPRESSION_H

//#include <qstring.h>
#include <qcolor.h>
#ifdef GLGRAPH
#include <qgl.h>
#endif //GLGRAPH

#include <string>
//#include <map>

class FungParser;

/**
 * @author Fungmeista
 * @brief A simple class for holding a few parameters for an expression
 * @todo Limpame!
 */
class Expression
{
	public:
		Expression(){}
		Expression(const Expression &);

		Expression( const char * expression1, bool show = true, QColor color = QColor());
		Expression( const char * expression1, const char * expression2, bool show, QColor color);
		#ifdef GLGRAPH
		Expression( std::string & expression1, bool show, QColor color, GLuint callListNumber);
		#endif //GLGRAPH

		~Expression();

		std::string getExpression(const char * functionName) const;

		void setParsedExpression( FungParser * fp, const char * functionName );
		FungParser * getParsedExpression( const char * functionName ) const;

		bool show;
		QColor color;

		#ifdef GLGRAPH
		GLuint name;
		#endif //GLGRAPH
		
	private:
		bool deleteable;

		std::string expression1;
		std::string expression2;
		
		FungParser *parsedExpression;
		FungParser *parsedExpression2;
		
};

#endif
