/***************************************************************************
                          fungparser.h  -  description
                             -------------------
    begin                : Wed Oct 9 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FUNGPARSER_H
#define FUNGPARSER_H

#include "fparser/fparser.hh"
#include "expression.h"

#include <qstring.h>
#include <vector>

/**
 * \author Fungmeista
 * \brief An ad hoc expression parsing class
 *  which is a wrapper for the real parser by Warp (warp@iki.fi).
 */
class FungParser : public FunctionParser
{
	public:
		FungParser();
		~FungParser();
	
		/** Parse the given expression.  Expressions is a QPtrList of Expression classes which is used to replace all
		  *  functions which are in terms of other functions.
		  */
		int Parse(std::string & expression, const char * dependent, const char * independent, std::vector<Expression*> &expressions,bool isDegrees);
		int Parse(const char * expression, const char *vars, bool isDegrees){return FunctionParser::Parse(expression,vars,isDegrees);}
};

#endif
