/***************************************************************************
                          fungvector.h  -  description
                             -------------------
    begin                : Thu Nov 7 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FUNGVECTOR_H
#define FUNGVECTOR_H

class SphericalCoord;
class CylindricalCoord;

/**
  *\author Fungmeista
  *\brief 3-D vector class for performing operations with vectors in three dimensional space.
  */
class FungVector
{
	public:
		FungVector(float x=0,float y=0,float z=0);
		FungVector(SphericalCoord &);
		FungVector(CylindricalCoord &);
		~FungVector();

		/** Calculates the normal vector for the given three vectors.  A normal vector is a vector perpendicular
		 * to the plane consisting of three given vectors.  No two vectors can lie on the same line.  The normal vector returned is
		 * the unit normal. */
		static FungVector normal(FungVector,FungVector,FungVector);

		/** Calculates the cross product of three vectors. */
		static void cross_product(FungVector &, FungVector &, FungVector &, FungVector *);

		/** Calculates the magnitude of a vector. */
		static float magnitude(FungVector &);

		/** Normalizes the given vector. */
		static void normalize(FungVector *);
		
		/** Puts the vector into a three dimensional array. */
		void toArray(float vec[3]);

		float x;
		float y;
		float z;
};
#endif //FungVector
