/***************************************************************************
                          glfunctiongraph.h  -  description
                             -------------------
    begin                : Fri Oct 18 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLFUNCTIONGRAPH_H
#define GLFUNCTIONGRAPH_H

#include "glexpressiongraph.h"

class Cartesian3DCoord;
class FungParser;

/**
 * \author Fungmeista
 * \brief Plots/graphs three dimensional implicit functions as "z" with respect to "x" and "y".  Currently this class is in alpha stage.
 */
class GLFunctionGraph : public GLExpressionGraph
{
	Q_OBJECT

	public: 
		GLFunctionGraph(QWidget *parent=0, const char *name=0);
		~GLFunctionGraph();

		virtual inline int getGraphType() const{return GLFUNCTIONGRAPH;}

	protected:
		const char * independent_vars() const{return "x,y";}
		const char * dependent_var() const{return "z";}
		void trace(GLfloat mouseX, GLfloat mouseY, FungParser &parsed_function, GLfloat *x, GLfloat *y, GLfloat *z);

		virtual Cartesian3DCoord2DVector getValues( FungParser &, GLfloat *, GLfloat * );
};

#endif

