#ifndef MODULE_BITMAP_BITMAP_ELEMENT_H
#define MODULE_BITMAP_BITMAP_ELEMENT_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
          \author Anders Dahnielson (anders@dahnielson.com)
*/

#include <k3dsdk/algebra.h>
#include <k3dsdk/bitmap.h>

namespace libk3dbitmap
{

/*
   The relationship between 'pixel space' and (2d) 'world space'

        | ------ w ----- |
      - +----------------+
      | | +-> u          | p s
        | |              | i p
      h | v      +       | x a
        |  v    c \      | e c
      | |          \     | l e
      - +-----------\----+
                     \
                      \            max
                 +-----------------+
                 |      \ ^ y      | w s
                 |       \|        | o p
                 |        +--> x   | r a
                 |       o         | l c
                 |                 | d e
                 +-----------------+
               min
*/

/// Class to treat bitmap as element in (2d) world space
/** \deprecated Move the transformation functions into the SDK, and revisit how to do 2D compositing as part of the pipeline */
class bitmap_element
{
public:
	/// Extremes in world space
	int min_x, max_x, min_y, max_y;

	bitmap_element(const k3d::bitmap& Bitmap);

	/// Return bitmap
	k3d::bitmap* get_bitmap();

	/// Return pixel value by world space coord
	const k3d::bitmap::pixel_type get_pixel(const int x, const int y);

/*
	/// Scale element
	void scale(const k3d::point2 scaling);

	/// Rotate element
	void rotate(double angle);

	/// Set element position
	void position(const k3d::point2 position);

	/// Color transform element
	void color(k3d::matrix4 const color_matrix, bool premultiplied);

	/// True tranlation
	void true_translation();
*/
private:
	int m_position_x, m_position_y;
	std::auto_ptr<k3d::bitmap> m_bitmap;

	void update_boundary();
/*
	void pad(const k3d::pixel_size_t left, const k3d::pixel_size_t right, const k3d::pixel_size_t top, const k3d::pixel_size_t bottom);
	void rotate_clockwise();
	void rotate_counter_clockwise();
	void rotate_180();
	void flip();
	void flop();
	void rotateOrtho(const int num_of_90s);
*/
};

} // namespace libk3dbitmap

#endif // !MODULE_BITMAP_BITMAP_ELEMENT_H

