#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qdialog.h>
#include <aalib.h>

class QLabel;
class QCheckBox;
class QSpinBox;
class QComboBox;

class MainWindow : public QDialog
{
    Q_OBJECT

    private:
        aa_context* context;
        aa_hardware_params params;
        aa_savedata saveData;

        int screenWidth,
            screenHeight;

        QLabel* image;
        QCheckBox* synchro;
        QComboBox* font,
                * format;
        QSpinBox* width,
                * height;

    public:
        MainWindow();
        void setupFont();
        void setupFormat();

    public slots:
        void openFile();
        void synchroChanged(int state);
        void convertToAA();
        void showPreview();
};

extern const int Major_Version;
extern const int Minor_Version;
extern const int Mini_Version;

#endif
