/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *   Copyright (C) 2005 Boaz Anin <boazanin@gmail.com>                     *
 *   Copyright (C) 2005 Shahar Karin <shaharka@post.tau.ac.il>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PHISH_SAFELIST_H
#define __PHISH_SAFELIST_H

#include "phish.h"
#include "phish_util_ll.h"


typedef phish_util_LinkedList phish_safelist_t;
typedef phish_util_ListElem phish_safelist_entry_t;

/** Creates a new, empty safe list.
 *  @param list pointer to pointer to safe list handle which will be assigned
 *              with address of newly created safe list.
 */
phish_result_t phish_safeList_new(phish_safelist_t **list);

/** Open a safe list file and loads the list of URLs in it.
 *  @param path location of safe list file
 *  @param list pointer to pointer to safe list handle which will be assigned
 *              with address of opened safe list for use with other functions
 */
phish_result_t phish_safelist_open(const char *path,
                                   phish_safelist_t **list);

/** Close a safe list.
 *  @param list pointer to safe list to close
 */
void phish_safelist_close(phish_safelist_t *list);

/** Writes the list of URLs from a safe list back into a file.
 *  @param path location of file to write safe list to
 *  @param list safe list to write to file
 */
phish_result_t phish_safelist_write(const char *path,
                                    phish_safelist_t *list);

/** Checks whether a URL is in safe list.
 *  @param url URL to check
 *  @param list safe list to use for checking
 *  @return 1 if URL is in safe list, 0 otherwise
 */
int phish_safelist_checkURL(const char *url, phish_safelist_t *list);

/** Adds a URL to a safe list.
 *  @param url URL to add
 *  @param list safe list to add URL to
 */
phish_result_t phish_safelist_add(const char *url, phish_safelist_t *list);

/** Returns the first entry in a safe list.
 *  @param list safe list
 */
phish_safelist_entry_t *phish_safelist_first(phish_safelist_t *list);

/** Returns the next entry after the given entry in a safe list.
 *  @param entry entry before the returned element
 */
phish_safelist_entry_t *phish_safelist_next(phish_safelist_entry_t *entry);

/** Returns the URL contained in a safe list entry. */
const char *phish_safelist_entryData(phish_safelist_entry_t *entry);


#endif /* __PHISH_SAFELIST_H */

