/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *   Copyright (C) 2005 Boaz Anin <boazanin@gmail.com>                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __PHISH_UTIL_LL_H
#define __PHISH_UTIL_LL_H


/** A list element */
typedef struct phish_util_ListElem
{
  /** pointer to actual data stored in list element */
  void *data;
  
  /** pointer to next list element */
  struct phish_util_ListElem *next;
} phish_util_ListElem;

/** Creates a new list element, with NULL data.
 *  @return pointer to new list element, NULL if error occurred
 */
phish_util_ListElem *phish_util_newListElem();

/** Returns the data contained in a list element.
 *  @param l list element
 */
void *phish_util_listData(phish_util_ListElem *l);

/** Sets the list element to hold new data.
 *  @param l list element to set
 *  @param d new data
 */
void phish_util_setListData(phish_util_ListElem *l, void *d);

/** Return the next element after the given element in a linked list.
 *  @param l list element
 */
phish_util_ListElem *phish_util_listNext(phish_util_ListElem *l);

/** Sets the list element to point to a new next element.
 *  @param l list element
 *  @param n element to set as next element
*/
void phish_util_setListNext(phish_util_ListElem *l, phish_util_ListElem *n);


/** A linked list structure. */
typedef struct
{
  /** pointer to the first element in the list */
  phish_util_ListElem *head;
  
  /** pointer to the last element in the list */
  phish_util_ListElem *tail;
  
  /** number of elements currently in the list */
  unsigned int length;
} phish_util_LinkedList;


/** Defines a new list with no elements.
 *  @return pointer to new list, NULL if error occurred
 */
phish_util_LinkedList *phish_util_newList();

/** Adds a new item to a given list.
 *  @param list linked list to add new element to
 *  @param newdata new data of element to be added to list
 */
void phish_util_addToList(phish_util_LinkedList *list, void *newdata);

/** Returns the list element at the head of the given list.
 *  @param list linked list
 */
phish_util_ListElem *phish_util_listHead(phish_util_LinkedList *list);

/** Deletes a list, only by deallocating the memory its elements use,
 *  without their pointed data
 *  @param list linked list to delete
 */
void phish_util_deleteList(phish_util_LinkedList *list);

/** Deletes a list and its pointed data.
 *  @param list linked list to delete
 */
void phish_util_deepDeleteList(phish_util_LinkedList *list);

/** Returns the length of a given linked list.
 *  @param list linked list
 */
unsigned int phish_util_listLength(const phish_util_LinkedList *list);


#endif /* __PHISH_UTIL_LL_H */

