#include <stdio.h>
#include <stdlib.h>
#include "../phish.h"
#include "../phish_config.h"

#define SETTINGS_FILE "config.txt"

int main(int argc, char *argv[])
{
  phish_loadSettings(SETTINGS_FILE);
  
  printf("Configuration is: \n");
  printf("mode = %d\n", phish_runningMode());
  printf("site_query_url = %s\n", phish_siteQueryURL());
  printf("country_checking_url = %s\n", phish_countryQueryURL());
  printf("report_site_url = %s\n", phish_reportSiteURL());
  printf("local_xml_location = %s\n", phish_localXMLFile());
  printf("remote_xml_url = %s\n", phish_remoteXMLURL());
  printf("safelist_file_location = %s\n", phish_safeListFile());
  printf("remote_xml_etag = %s\n", phish_remoteXMLETag());

  if (phish_writeSettings(SETTINGS_FILE) == PHISH_SUCCESS)
    printf("Saved successfully.\n");

  return 0;
}

