/***************************************************************************
 *   Copyright (C) 2005 Meni Livne <livne@kde.org>                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>

#include "../phish_util_net.h"


#define SERVER "dobravoda.livne.org"
#define PORT 80
#define HOST "dobravoda.livne.org"
#define PATH "/opdbsites.xml"
#define UA "Foo/1.0"
#define REFERRER NULL

int main(int argc, char *argv[])
{
  int sock;
  phish_result_t result;
  phish_util_http_headers_t headers;
  
  headers.etag = NULL;
  
  /* create socket */
  sock = socket(PF_INET, SOCK_STREAM, 0);
  if (sock == -1)
  {
    perror("error creating socket");
    exit(1);
  }
  
  result = phish_util_tcpConnect(sock, SERVER, PORT);
  if (result != PHISH_SUCCESS)
  {
    fprintf(stderr, "Error connecting to server");
    close(sock);
    exit(1);
  }
  
  result = phish_util_httpGet(sock, PATH, "1.0", HOST, UA, REFERRER, NULL, 0);
  
  result = phish_util_parseHTTPReply(sock, &headers);
  
  printf("Status: %d\nLength: %d\nETag: %s\n", headers.status_code,
                                               headers.content_length,
                                               headers.etag == NULL ? "(none)" : headers.etag);

  close(sock);
  
  return 0;
}

