/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "addiktconfigchild.h"
#include <kcolorbutton.h>
#include <kcombobox.h>
#include <kconfig.h>
#include <kfontdialog.h>
#include <kpushbutton.h>
#include <kmessagebox.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <knuminput.h>
#include <qlabel.h>
#include <qstring.h>
#include <qradiobutton.h>
addiKtConfigChild::addiKtConfigChild(QWidget* parent, const char* name, WFlags fl) : ConfigDialog(parent,name,fl){
    reopen();
    connect(cmdDefault, SIGNAL(clicked()), this, SLOT(slotDefaultClicked()));
    connect(cmdOSDSelectFont, SIGNAL(clicked()), this, SLOT(slotOSDSelectFontClicked()));
    connect(cobOSDTxtCol, SIGNAL(clicked()), this , SLOT(slotOSDTextColourChanged()));
    connect(cobOSDBgCol, SIGNAL(clicked()), this , SLOT(slotOSDBgColourChanged()));
    connect(cmbColourScheme, SIGNAL(activated(int)), this, SLOT(slotOSDColourSchemeChanged(int)));
}

addiKtConfigChild::~addiKtConfigChild(){
}

void addiKtConfigChild::save(){
    KConfig &config = *KGlobal::config();
//Interface
    config.setGroup("addiKtUI");
    config.writeEntry("ExitOnClose", chbExitOnClose->isChecked());
    config.writeEntry("Visualisation", cmbDefVis->currentItem() - 1);
//Blur Scope
    config.writeEntry("BS_Colour_Cycle", cbBSCycleColour->isChecked());
    QColor colTemp = cobBSDefCol->color();
    config.writeEntry("BS_R", colTemp.red());
    config.writeEntry("BS_G", colTemp.green());
    config.writeEntry("BS_B", colTemp.blue());
    config.writeEntry("BS_QUALITY_BEST", rbBSQualityBest->isOn());
    config.writeEntry("BS_QUALITY_USER", rbBSQualityUser->isOn());
    config.writeEntry("BS_RESOLUTION_WIDTH", isbBSWidth->value());
    config.writeEntry("BS_RESOLUTION_HEIGHT", isbBSHeight->value());
//Spectrum Analyser
    config.writeEntry("SA_Peaks", cbSAShowPeaks->isChecked());
    colTemp = cobSABotCol->color();
    config.writeEntry("SA_R1", colTemp.red());
    config.writeEntry("SA_G1", colTemp.green());
    config.writeEntry("SA_B1", colTemp.blue());
    colTemp = cobSAMidCol->color();
    config.writeEntry("SA_R2", colTemp.red());
    config.writeEntry("SA_G2", colTemp.green());
    config.writeEntry("SA_B2", colTemp.blue());
    colTemp = cobSATopCol->color();
    config.writeEntry("SA_R3", colTemp.red());
    config.writeEntry("SA_G3", colTemp.green());
    config.writeEntry("SA_B3", colTemp.blue());
    colTemp = cobSAPeakCol->color();
    config.writeEntry("SA_R4", colTemp.red());
    config.writeEntry("SA_G4", colTemp.green());
    config.writeEntry("SA_B4", colTemp.blue());
    config.writeEntry("SA_BAR_SIZE_STATIC", rbSAStatic->isOn());
    config.writeEntry("SA_BAR_SIZE_DYNAMIC", rbSADynamic->isOn());
    config.writeEntry("SA_BAR_WIDTH", isbSAWidth->value());
    config.writeEntry("SA_BAR_HEIGHT", isbSAHeight->value());
    config.writeEntry("SA_BAR_ALONG_X", isbSAAlongX->value());
    config.writeEntry("SA_BAR_ALONG_Y", isbSAAlongY->value());
//OSD
    colTemp = cobOSDTxtCol->color();
    config.writeEntry("OSD_R", colTemp.red());
    config.writeEntry("OSD_G", colTemp.green());
    config.writeEntry("OSD_B", colTemp.blue());
    colTemp = cobOSDBgCol->color();
    config.writeEntry("OSD_BR", colTemp.red());
    config.writeEntry("OSD_BG", colTemp.green());
    config.writeEntry("OSD_BB", colTemp.blue());
    config.writeEntry("OSD_ColourOption", cmbColourScheme->currentItem());
    config.writeEntry("OSD_Sec_Display", spbOSDSecDisplay->value());
    config.writeEntry("OSD_Font", font);

    config.sync();
}

void addiKtConfigChild::reopen(){
    KConfig &config = *KGlobal::config();
    config.setGroup("addiKtUI");
//Interface
    int temp = config.readNumEntry("Visualisation", 1);
    switch( temp ){
        case -1://Random
        case 0://Previous
        case 1://BS
        case 2://BS
        case 3://SA
            break;
        default:
            temp = 1;//BS
    }
    cmbDefVis->setCurrentItem(temp + 1);
    chbExitOnClose->setChecked(config.readBoolEntry("ExitOnClose", TRUE));
//Blur Scope
    cbBSCycleColour->setChecked(config.readBoolEntry("BS_Colour_Cycle", TRUE));
    int defRed = config.readNumEntry("BS_R", 255);
    int defGreen = config.readNumEntry("BS_G", 0);
    int defBlue = config.readNumEntry("BS_B", 0);
    cobBSDefCol->setColor(QColor(defRed, defGreen, defBlue));
    rbBSQualityBest->setChecked(config.readBoolEntry("BS_QUALITY_BEST", FALSE));
    rbBSQualityUser->setChecked(config.readBoolEntry("BS_QUALITY_USER", TRUE));
    isbBSWidth->setValue(config.readNumEntry("BS_RESOLUTION_WIDTH", 320));
    isbBSHeight->setValue(config.readNumEntry("BS_RESOLUTION_HEIGHT", 240));
//Spectrum Analyser
    cbSAShowPeaks->setChecked(config.readBoolEntry("SA_Peaks", TRUE));
    defRed = config.readNumEntry("SA_R1", 0);
    defGreen = config.readNumEntry("SA_G1", 255);
    defBlue = config.readNumEntry("SA_B1", 0);
    cobSABotCol->setColor(QColor(defRed, defGreen, defBlue));
    defRed = config.readNumEntry("SA_R2", 255);
    defGreen = config.readNumEntry("SA_G2", 255);
    defBlue = config.readNumEntry("SA_B2", 0);
    cobSAMidCol->setColor(QColor(defRed, defGreen, defBlue));
    defRed = config.readNumEntry("SA_R3", 255);
    defGreen = config.readNumEntry("SA_G3", 0);
    defBlue = config.readNumEntry("SA_B3", 0);
    cobSATopCol->setColor(QColor(defRed, defGreen, defBlue));
    defRed = config.readNumEntry("SA_R4", 255);
    defGreen = config.readNumEntry("SA_G4", 0);
    defBlue = config.readNumEntry("SA_B4", 0);
    cobSAPeakCol->setColor(QColor(defRed, defGreen, defBlue));
    rbSAStatic->setChecked(config.readBoolEntry("SA_BAR_SIZE_STATIC", TRUE));
    rbSADynamic->setChecked(config.readBoolEntry("SA_BAR_SIZE_DYNAMIC", FALSE));
    isbSAWidth->setValue(config.readNumEntry("SA_BAR_WIDTH", 20));
    isbSAHeight->setValue(config.readNumEntry("SA_BAR_HEIGHT", 2));
    isbSAAlongX->setValue(config.readNumEntry("SA_BAR_ALONG_X", 10));
    isbSAAlongY->setValue(config.readNumEntry("SA_BAR_ALONG_Y", 15));
//OSD
    defRed = config.readNumEntry("OSD_BR", 255);
    defGreen = config.readNumEntry("OSD_BG", 255);
    defBlue = config.readNumEntry("OSD_BB", 255);
    cobOSDBgCol->setColor(QColor(defRed, defGreen, defBlue));
    temp = config.readNumEntry("OSD_Sec_Display", 5);
    cmbColourScheme->setCurrentItem(config.readNumEntry("OSD_ColourOption", 1));//1=Title
    defRed = config.readNumEntry("OSD_R", 255);
    defGreen = config.readNumEntry("OSD_G", 0);
    defBlue = config.readNumEntry("OSD_B", 0);
    cobOSDTxtCol->setColor(QColor(defRed, defGreen, defBlue));
    spbOSDSecDisplay->setValue(temp);
    font = KGlobalSettings::generalFont();
    font = config.readFontEntry("OSD_Font", &font);
    lblFont->setFont(font);

    switch( cmbColourScheme->currentItem()){
    case 0:
        lblFont->unsetPalette();
        break;
    case 1:
        lblFont->setPaletteForegroundColor(KGlobalSettings::activeTextColor());
        lblFont->setPaletteBackgroundColor(KGlobalSettings::activeTitleColor());
        break;
    case 2:
        //backgrounf colour
        defRed = config.readNumEntry("OSD_BR", 255);
        defGreen = config.readNumEntry("OSD_BG", 255);
        defBlue = config.readNumEntry("OSD_BB", 255);
        lblFont->setPaletteBackgroundColor(QColor(defRed, defGreen, defBlue));
        //foregrount colour
        defRed = config.readNumEntry("OSD_R", 255);
        defGreen = config.readNumEntry("OSD_G", 0);
        defBlue = config.readNumEntry("OSD_B", 0);
        lblFont->setPaletteForegroundColor(QColor(defRed, defGreen, defBlue));
        break;
    }
    config.sync();
}

void addiKtConfigChild::slotDefaultClicked(){
//Interface
    cmbDefVis->setCurrentItem(2);
    chbExitOnClose->setChecked(TRUE);
//Blur Scope
    cbBSCycleColour->setChecked(TRUE);
    cobBSDefCol->setColor(QColor(255, 0, 0));
    rbBSQualityBest->setChecked(FALSE);
    rbBSQualityUser->setChecked(TRUE);
    isbBSWidth->setValue(320);
    isbBSHeight->setValue(240);
//Spectrum Analyser
    cbSAShowPeaks->setChecked(TRUE);
    cobSABotCol->setColor(QColor(0, 255, 0));
    cobSAMidCol->setColor(QColor(255, 255, 0));
    cobSATopCol->setColor(QColor(255, 0, 0));
    cobSAPeakCol->setColor(QColor(255, 0, 0));
    rbSAStatic->setChecked(TRUE);
    rbSADynamic->setChecked(FALSE);
    isbSAWidth->setValue(20);
    isbSAHeight->setValue(2);
    isbSAAlongX->setValue(10);
    isbSAAlongY->setValue(15);
//OSD
    cobOSDTxtCol->setColor(QColor(255, 0, 0));
    cobOSDBgCol->setColor(QColor(255, 255, 255));
    cmbColourScheme->setCurrentItem(1);
    spbOSDSecDisplay->setValue(5);
    font = KGlobalSettings::generalFont();
    lblFont->setFont(font);
    switch( cmbColourScheme->currentItem()){
    case 0:
        lblFont->unsetPalette();
        break;
    case 1:
        lblFont->setPaletteForegroundColor(KGlobalSettings::activeTextColor());
        lblFont->setPaletteBackgroundColor(KGlobalSettings::activeTitleColor());
        break;
    case 2:
        lblFont->setPaletteForegroundColor(cobOSDTxtCol->color());
        lblFont->setPaletteBackgroundColor(cobOSDBgCol->color());
        break;
    }
}

void addiKtConfigChild::slotOSDSelectFontClicked(){
    KFontDialog::getFont(font);
    lblFont->setFont(font);
}

void addiKtConfigChild::slotOSDTextColourChanged(){
    lblFont->setPaletteForegroundColor(cobOSDTxtCol->color());
}

void addiKtConfigChild::slotOSDBgColourChanged(){
    lblFont->setPaletteBackgroundColor(cobOSDBgCol->color());
}

void addiKtConfigChild::slotOSDColourSchemeChanged(int i){
    switch(i){
    case 0:
        lblFont->unsetPalette();
        break;
    case 1:
        lblFont->setPaletteForegroundColor(KGlobalSettings::activeTextColor());
        lblFont->setPaletteBackgroundColor(KGlobalSettings::activeTitleColor());
        break;
    case 2:
        lblFont->setPaletteForegroundColor(cobOSDTxtCol->color());
        lblFont->setPaletteBackgroundColor(cobOSDBgCol->color());
        break;
    }
}

#include "addiktconfigchild.moc"
