/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BLURSCOPEEXT_H
#define BLURSCOPEEXT_H

#include "rvisualisation.h"

class BlurscopeExt : public RVisualisation,  public MonoScope{
Q_OBJECT
public:
    BlurscopeExt(QWidget *parent = 0, const char *name = 0);
    ~BlurscopeExt();
    void reloadSettings(void);
    virtual void setOn(bool);
protected:
    void initializeGL();
    void paintGL();
    void resizeGL( int w, int h );
protected:
    virtual void scopeEvent(float *data, int bands);
    virtual void mouseReleaseEvent(QMouseEvent *);
private:
    bool mQualityBest, mQualityUser;
    int mUserResolutionWidth, mUserResolutionHeight;
    unsigned int bufSize;
    GLubyte *myBuffer;
    bool isOn, myOn;
    int _width, _height;
    int cycle;
    GLubyte defRed, defGreen, defBlue;
    GLfloat r, g, b;
    bool colCycle;
    void drawVertLine(GLsizei xPos, GLsizei y1Pos, GLsizei y2Pos, GLubyte rCol, GLubyte gCol, GLubyte bCol);
    void drawPixel(GLsizei xPos, GLsizei yPos, GLubyte rCol, GLubyte gCol, GLubyte bCol);
};

#endif
