/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ADDIKT_IMPL_H
#define ADDIKT_IMPL_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <noatun/plugin.h>
#include <noatun/app.h>
#include <noatun/pref.h>
#include <kmainwindow.h>
#include <qlayout.h>
#include <qpixmap.h>
#include <kpopupmenu.h>
#include <noatun/video.h>
class ROnScreenDisplay;
class RSystemTray;
class RScrollingLabel;
class RVisualisation;
class Player;
class QSlider;
class QPushButton;
class addiKt : public KMainWindow, public UserInterface{
Q_OBJECT
public:
    addiKt();
    ~addiKt();
    void load(const QString& url);

protected:
    virtual void dragEnterEvent(QDragEnterEvent *);
    virtual void dropEvent(QDropEvent *);
    virtual void closeEvent(QCloseEvent*);
    /** RMB -> context menu  */
    virtual void mouseReleaseEvent(QMouseEvent *);
    virtual bool eventFilter(QObject *, QEvent *);
    /** volume control  */
    virtual void wheelEvent(QWheelEvent *);
    virtual void hideEvent(QHideEvent *);
    virtual void showEvent(QShowEvent *);
    virtual void resizeEvent(QResizeEvent *);

protected:
    QSlider *seeker() const { return mSeeker; }

public slots:
    void slotPlaying();
    void slotStopped();
    void slotPaused();

    void playlistShown();
    void playlistHidden();

    void slotTimeout();
    void sliderMoved(int seconds);
    void changeLoopType(int t);
    inline void skipToWrapper(int second);

signals:
    void skipTo( int ); // emitted by skipToWrapper()

private slots:
    void changeStatusbar(const QString& text, const QString &text2=0);
    inline void changeCaption(const QString& text);
    void popup();
    void switchVisualisation(int vis_no);
    void loadSettings();
    void toggleShow(void);
    void _hide();
    void _show();
    void adaptSize(int, int);
    void showVideoWindow();
    void hideVideoWindow();
    void sizeChanged();
private:
    KPopupMenu *visMenu/*, *m_pVideoContextMenu*/;
    RSystemTray *mSysTray;
    QVBoxLayout *mainLayout;
    QHBoxLayout *thirdLineLayout, *fourthLineLayout;
    QLabel *lblTime;
    QPushButton *mBack, *mStop, *mPlay, *mForward, *mPlaylist, *mLoop;
    QSlider *mSeeker, *mVolume;
    ROnScreenDisplay *osdDisplay;
    RVisualisation *mVis;
    RScrollingLabel *scrTitle;
    VideoFrame *mVideo;
    bool visOn, exitOnClose;
    int curVis;
    int totVis;
    bool visActive;
    QSize mMinimumSize;
    QString mSizeString;
};

#endif // ADDIKT_IMPL_H
