/***************************************************************************
 *   Copyright (C) 2004 by Yogesh                                          *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kwin.h>
#include <kconfig.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <qapplication.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtimer.h>

#include "ronscreendisplay.h"

ROnScreenDisplay::ROnScreenDisplay() : QWidget(0, "ROnScreenDisplay", WStyle_Customize|WStyle_StaysOnTop|WStyle_NoBorderEx| WX11BypassWM){
    KWin::setState( winId(), NET::Modal | NET::Sticky | NET::StaysOnTop | NET::SkipTaskbar | NET::SkipPager );
    KWin::setOnAllDesktops( winId(), NET::Override );
    status = Stopped;
    strApp = QString("addiKt: ");
    enabled = TRUE;
    hide();
    connect(&tmrToHide, SIGNAL(timeout()), this, SLOT(hide()));
}

ROnScreenDisplay::~ROnScreenDisplay(){
}

void ROnScreenDisplay::setVolume(int vol){
    QString strTitle;
    switch( status ){
    case Playing:
        strTitle = "Playing";
        break;
    case Stopped:
        strTitle = "Idle";
        break;
    case Paused:
        strTitle = "Paused";
    }
    renderPixmap(strApp + strTitle, QString("Volume: %1%").arg(vol));
    if(enabled)
        show();
    tmrToHide.start(time, TRUE);
}

void ROnScreenDisplay::setSong(QString s){
    QString strTitle;
    switch( status ){
    case Playing:
        strTitle = "Playing";
        break;
    case Stopped:
        strTitle = "Stopped";
        break;
    case Paused:
        strTitle = "Paused";
    }
    strSong = s;
    reload();
    renderPixmap(strApp + strTitle, strSong);
    if(enabled)
        show();
    tmrToHide.start(time, TRUE);
}

void ROnScreenDisplay::setStatus(Status st){
    status = st;
    QString strTitle;
    switch( status ){
    case Playing:
        strTitle = "Playing";
        break;
    case Stopped:
        strTitle = "Stopped";
        break;
    case Paused:
        strTitle = "Paused";
    }
    renderPixmap(strApp + strTitle, strSong);
    if(enabled)
        show();
    tmrToHide.start(time, TRUE);
}

void ROnScreenDisplay::reload(void){
    KConfig &config = *KGlobal::config();
    config.setGroup("addiKtUI");

    int option = config.readNumEntry("OSD_ColourOption", 1);//1=Title

    int defRed, defGreen, defBlue;
    int defBRed, defBGreen, defBBlue;

    switch( option ){
    case 0:
        unsetPalette();
        break;
    case 1:
        setPaletteForegroundColor(KGlobalSettings::activeTextColor());
        setPaletteBackgroundColor(KGlobalSettings::activeTitleColor());
        break;
    case 2:
        //foreground colour
        defRed = config.readNumEntry("OSD_R", 255);
        defGreen = config.readNumEntry("OSD_G", 0);
        defBlue = config.readNumEntry("OSD_B", 0);
        //backgrounf colour
        defBRed = config.readNumEntry("OSD_BR", 255);
        defBGreen = config.readNumEntry("OSD_BG", 255);
        defBBlue = config.readNumEntry("OSD_BB", 255);
        setPaletteBackgroundColor(QColor(defBRed, defBGreen, defBBlue));
        setPaletteForegroundColor(QColor(defRed, defGreen, defBlue));
    }
    messageFont = KGlobalSettings::generalFont();
    messageFont = config.readFontEntry("OSD_Font", &messageFont);
    time = config.readNumEntry("OSD_Sec_Display", 5) * 1000;
    if(time == 0)
        enabled = false;
    else
        enabled = TRUE;
}

void ROnScreenDisplay::renderPixmap(QString strTitle, QString strMessage){
    QBitmap mask;
    QSize maxSize = QApplication::desktop()->size();
    maxSize -= QSize(50, maxSize.height()/2);
    QFont titleFont("Serif", 12, QFont::Bold);
    QFontMetrics titleFM(titleFont);
    QRect titleRect = titleFM.boundingRect( 0, 0, maxSize.width(), titleFM.height(), AlignAuto, strTitle);
    QFontMetrics messageFM(messageFont);
    QRect messageRect = messageFM.boundingRect( 0, 0, maxSize.width(), maxSize.height(), AlignLeft|WordBreak, strMessage);
    if (messageRect.width() < titleRect.width())
        messageRect.setWidth(titleRect.width());
    messageRect.setX(0);
    messageRect.setY(0);
    messageRect.addCoords( 0, 0, 20, titleRect.height() );
    m_osd.resize(messageRect.size());
    mask.resize(messageRect.size());
    m_osd.fill(backgroundColor());
    QPainter bufferPainter(&m_osd);
    QPainter maskPainter(&mask);
    bufferPainter.setPen( Qt::black );
    bufferPainter.setBrush( backgroundColor() );
    bufferPainter.drawRoundRect( messageRect, 1500 / messageRect.width(), 1500 / messageRect.height() );
    bufferPainter.setPen(foregroundColor());
    bufferPainter.setFont(titleFont);
    bufferPainter.drawText( 10, 0, titleRect.width(), titleRect.height(), AlignAuto, strTitle);
    bufferPainter.setFont(messageFont);
    bufferPainter.drawText( 10, titleFM.height(), messageRect.width(), messageRect.height(), AlignLeft| WordBreak, strMessage);

    mask.fill( Qt::black );
    maskPainter.setBrush( Qt::white );
    maskPainter.drawRoundRect( messageRect, 1500 / messageRect.width(), 1500 / messageRect.height() );
    setMask( mask );

    resize(messageRect.size());
    move( (QApplication::desktop()->width()-width())/2, QApplication::desktop()->height() - height() - 50);
    update();
}

void ROnScreenDisplay::paintEvent(QPaintEvent *){
    bitBlt( this, 0, 0, &m_osd);
}

#include "ronscreendisplay.moc"
