/***************************************************************************
 *   Copyright (C) 2004 by Yogesh                                          *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RONSCREENDISPLAY_H
#define RONSCREENDISPLAY_H

#include <qwidget.h>

class QPixmap;
class QTimer;

class ROnScreenDisplay : public QWidget{
Q_OBJECT
public:
    enum Status{Playing, Paused, Stopped};
    ROnScreenDisplay();
    ~ROnScreenDisplay();
public slots:
    void setSong(QString s);
    void setStatus(Status st);
    void setVolume(int vol);
    void reload(void);
private:
    QPixmap m_osd;
    QPixmap m_osdMask;
    QTimer tmrToHide;
    QString strSong;
    Status status;
    QString strApp;
    QFont messageFont;
    int time;
    bool enabled;
    void renderPixmap(QString strTitle, QString strMessage);
    void paintEvent(QPaintEvent *evt);
};

#endif
