/***************************************************************************
 *   Copyright (C) 2004 by Yogesh                                          *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *

 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfontmetrics.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <klocale.h>
#include "rscrollinglabel.h"
RScrollingLabel::RScrollingLabel(QWidget *parent, const char *name) : QWidget(parent, name){
    scrollStartX = 0;
    shakeStartX = 0;
    scrolling = FALSE;
    connect(&tmrScroll, SIGNAL(timeout()), this, SLOT(drawScrollContents()));
    connect(&tmrFlash, SIGNAL(timeout()), this, SLOT(restart()));
    connect(&tmrShake, SIGNAL(timeout()), this, SLOT(drawShakeContents()));
    tmrScroll.start(30);
    setText(i18n("Going To Be addiKted!"));
}

RScrollingLabel::~RScrollingLabel(){
}

void RScrollingLabel::setText(QString str, bool force){
    if(!force)
        if (strText.compare(str) == 0)
            return;
        else
            scrollStartX = 0;
    tmrScroll.stop();
    tmrShake.stop();
    strText = str;
    QFontMetrics fm( font() );
    const int _width = fm.width(strText);
    const int _height = fm.height() + 2; //a bit of extra space
    if(_width >= width()){
        pixText.resize(_width + width(), _height);
        pixText.fill(this, 0, 0);
        QPainter paint(&pixText);
        paint.setPen(foregroundColor());
        //FIXME: find an exact (i.e. correct) point to draw instead of an approximation
        paint.drawText(width(), _height - 4, strText);
        paint.end();
        scrolling = TRUE;
        tmrScroll.start(30);
    }else{
        pixText.resize((width() - _width) * 2 + _width, _height);
        shakeLeftExtreme = width() - _width;
        pixText.fill(this, 0, 0);
        QPainter paint(&pixText);
        paint.setPen(foregroundColor());
        paint.drawText(width() - _width, _height - 4, str);
        paint.end();
        scrolling = FALSE;
        tmrShake.start(30);
    }
    setFixedHeight(_height);
}

void RScrollingLabel::setTextFlash(QString str, int time = 2000){
    if(str.isNull()) return;
    tmrScroll.stop();
    tmrShake.stop();
    QFontMetrics fm( font() );
    const int _width = fm.width(str);
    const int _height = fm.height() + 2; //a bit of extra space
    QPixmap pixTemp;
    pixTemp.resize(width(), _height);
    pixTemp.fill(this, 0, 0);
    QPainter paint(&pixTemp);
    paint.setPen(foregroundColor());
    paint.drawText((width()/2)-(_width/2), _height - 4, str);
    paint.end();
    bitBlt(this, 0, 0, &pixTemp, 0, 0, width(), pixText.height(), Qt::CopyROP);
    tmrFlash.start(time);
}

void RScrollingLabel::restart(){
    scrollStartX = 0;
    shakeStartX = 0;
    tmrFlash.stop();
    if(scrolling)
        tmrScroll.start(30);
    else
        tmrShake.start(30);
}

void RScrollingLabel::drawScrollContents(){
    if(++scrollStartX > pixText.width())
        scrollStartX = 0;
    bitBlt(this, 0, 0, &pixText, scrollStartX, 0, width(), pixText.height(), Qt::CopyROP);
}

void RScrollingLabel::drawShakeContents(){
    if(shakeStartX == shakeLeftExtreme)
        shakeDirToRight = TRUE;
    else
    if(shakeStartX == 0)
        shakeDirToRight = FALSE;
    if(shakeDirToRight)
        --shakeStartX;
    else
        ++shakeStartX;
    bitBlt(this, 0, 0, &pixText, shakeStartX, 0, width(), pixText.height(), Qt::CopyROP);
}

void RScrollingLabel::paintEvent(QPaintEvent *){
    setText(strText, TRUE);
}

#include "rscrollinglabel.moc"
