/***************************************************************************
 *   Copyright (C) 2004 by Yogesh                                          *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RSCROLLINGLABEL_H
#define RSCROLLINGLABEL_H

#include <qwidget.h>

class QPixmap;
class RScrollingLabel : public QWidget{
Q_OBJECT
    QString strText;
    QPixmap pixText;
    int scrollStartX, shakeStartX, shakeLeftExtreme;
    bool shakeDirToRight;
    QTimer tmrScroll, tmrShake, tmrFlash;
    bool scrolling;
private slots:
    void drawScrollContents();
    void drawShakeContents();
    void restart();
protected:
    void paintEvent(QPaintEvent *);
public:
    RScrollingLabel(QWidget *parent = 0, const char *name = 0);
    ~RScrollingLabel();
    void setText(QString str, bool force = FALSE);
    void setTextFlash(QString str, int time);
};

#endif
