/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <kiconloader.h>
#include <kpopupmenu.h>

#include "rsystemtray.h"

#define PLAY_ITEM 1
#define PAUSE_ITEM 2
#define STOP_ITEM 3
#define PLAY_PREV_ITEM 4
#define PLAY_NEXT_ITEM 5
#define OPEN_ITEM 6
#define PLAYLIST_ITEM 7
#define CONFIG_ITEM 8
#define QUIT_ITEM 9
#define LOOP_ITEM 10
#define LOOP_NONE_ITEM 11
#define LOOP_SONG_ITEM 12
#define LOOP_PLAYLIST_ITEM 13
#define LOOP_RANDOM_ITEM 14
#define EQUALISER_ITEM 15
#define EFFECTS_ITEM 16
#include <klocale.h>
RSystemTray::RSystemTray(QWidget*parent, const char *name) : KSystemTray(parent, name){
    state = RSystemTray::Stopped;
    loop = Player::None;
    playlistVisible = false;
}

void RSystemTray::mousePressEvent(QMouseEvent *event){
    KPopupMenu popupMenu;
    popupMenu.insertTitle(BarIcon("noatun"), i18n("Noatun"));
    popupMenu.insertItem(SmallIcon("fileopen"), i18n("Open ..."), OPEN_ITEM);
    if(playlistVisible)
        popupMenu.insertItem(SmallIcon("playlist"), i18n("Hide Playlist"), PLAYLIST_ITEM);
    else
        popupMenu.insertItem(SmallIcon("playlist"), i18n("Show Playlist"), PLAYLIST_ITEM);
    popupMenu.insertSeparator();
    popupMenu.insertItem(SmallIcon("player_start"), i18n("Play Previous Track"), PLAY_PREV_ITEM);
    if(state == Playing)
        popupMenu.insertItem(SmallIcon("player_pause"), i18n("Pause"), PAUSE_ITEM);
    else
        popupMenu.insertItem(SmallIcon("player_play"), i18n("Play"), PLAY_ITEM);
    popupMenu.insertItem(SmallIcon("player_stop"), i18n("Stop"), STOP_ITEM);
    if(state == Stopped)
        popupMenu.setItemEnabled(STOP_ITEM, false);
    popupMenu.insertItem(SmallIcon("player_end"), i18n("Play Next Track"), PLAY_NEXT_ITEM);
    popupMenu.insertSeparator();
    KPopupMenu loopMenu;
    loopMenu.insertItem(SmallIcon("noatunloopnone"), i18n("None"), LOOP_NONE_ITEM);
    loopMenu.insertItem(SmallIcon("noatunloopsong"), i18n("Song"), LOOP_SONG_ITEM);
    loopMenu.insertItem(SmallIcon("noatunloopplaylist"), i18n("Playlist"), LOOP_PLAYLIST_ITEM);
    loopMenu.insertItem(SmallIcon("noatunlooprandom"), i18n("Random"), LOOP_RANDOM_ITEM);
    switch(loop){
    case Player::None:
        loopMenu.setItemChecked(LOOP_NONE_ITEM, true);
        popupMenu.insertItem(SmallIcon("noatunloopnone"), i18n("Loop Type"), &loopMenu, LOOP_ITEM);
        break;
    case Player::Song:
        loopMenu.setItemChecked(LOOP_SONG_ITEM, true);
        popupMenu.insertItem(SmallIcon("noatunloopsong"), i18n("Loop Type"), &loopMenu, LOOP_ITEM);
        break;
    case Player::Playlist:
        loopMenu.setItemChecked(LOOP_PLAYLIST_ITEM, true);
        popupMenu.insertItem(SmallIcon("noatunloopplaylist"), i18n("Loop Type"), &loopMenu, LOOP_ITEM);
        break;
    case Player::Random:
        loopMenu.setItemChecked(LOOP_RANDOM_ITEM, true);
        popupMenu.insertItem(SmallIcon("noatunlooprandom"), i18n("Loop Type"), &loopMenu, LOOP_ITEM);
        break;
    }
    popupMenu.insertItem(SmallIcon("equalizer"), i18n("Equaliser ..."), EQUALISER_ITEM);
    popupMenu.insertItem(SmallIcon("effect"), i18n("Effects ..."), EFFECTS_ITEM);
    popupMenu.insertSeparator();
    popupMenu.insertItem(SmallIcon("configure"), i18n("Configure Noatun ..."), CONFIG_ITEM);
    popupMenu.insertSeparator();
    popupMenu.insertItem(SmallIcon("exit"), i18n("Quit"), QUIT_ITEM);
    switch(event->button()){
    case LeftButton:
        emit toggleShow();
        break;
    case RightButton:
        switch(popupMenu.exec(event->globalPos())){
        case PLAY_ITEM:
        case PAUSE_ITEM:
            emit playPause();
            break;
        case STOP_ITEM:
            emit stop();
            break;
        case PLAY_PREV_ITEM:
            emit playPrev();
            break;
        case PLAY_NEXT_ITEM:
            emit playNext();
            break;
        case LOOP_NONE_ITEM:
            emit loopType(Player::None);
            break;
        case LOOP_SONG_ITEM:
            emit loopType(Player::Song);
            break;
        case LOOP_PLAYLIST_ITEM:
            emit loopType(Player::Playlist);
            break;
        case LOOP_RANDOM_ITEM:
            emit loopType(Player::Random);
            break;
        case PLAYLIST_ITEM:
            emit toggleListView();
            break;
        case OPEN_ITEM:
            napp->fileOpen();
            break;
        case EQUALISER_ITEM:
            napp->equalizerView();
            break;
        case EFFECTS_ITEM:
            napp->effectView();
            break;
        case CONFIG_ITEM:
            napp->preferences();
            break;
        case QUIT_ITEM:
            napp->quit();
            break;
        }
        break;
    default:
        break;
    }
}

RSystemTray::~RSystemTray(){
}

void RSystemTray::setLoopType(Player::LoopType l){
    loop = l;
}

void RSystemTray::setState(State s){
    state = s;
}

#undef PLAY_ITEM
#undef PAUSE_ITEM
#undef STOP_ITEM
#undef PLAY_PREV_ITEM
#undef PLAY_NEXT_ITEM
#undef OPEN_ITEM
#undef PLAYLIST_ITEM
#undef CONFIG_ITEM
#undef QUIT_ITEM
#undef LOOP_ITEM
#undef LOOP_NONE_ITEM
#undef LOOP_SONG_ITEM
#undef LOOP_PLAYLIST_ITEM
#undef LOOP_RANDOM_ITEM
#undef EQUALISER_ITEM
#undef EFFECTS_ITEM

#include "rsystemtray.moc"
