/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RSYSTEMTRAY_H
#define RSYSTEMTRAY_H

#include <ksystemtray.h>
#include <noatun/player.h>
#include <noatun/plugin.h>

class RSystemTray : public KSystemTray{
Q_OBJECT
public:
    enum State{Playing, Paused, Stopped};
    RSystemTray(QWidget *parent = 0, const char *name = 0);
    ~RSystemTray();
    void setState(State s);
    void setLoopType(Player::LoopType l);
    State state;
    Player::LoopType loop;
    bool playlistVisible;
protected:
    virtual void mousePressEvent(QMouseEvent *event);
signals:
    void toggleShow();
    void playPrev();
    void playNext();
    void playPause();
    void stop();
    void loopType(int);
    void toggleListView();
};

#endif
