/***************************************************************************
 *   Copyright (C) 2004 by Yogesh Marwaha                                  *
 *   yogeshm02@rediffmail.com                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SPECTRUMANALYSER_H
#define SPECTRUMANALYSER_H

#include "rvisualisation.h"
#define PEAK_DELAY_IN_FRAMES 10

class SpectrumAnalyser : public RVisualisation, public StereoFFTScope{
Q_OBJECT
public:
    SpectrumAnalyser(QWidget *parent = 0, const char *name = 0);
    ~SpectrumAnalyser();
    void reloadSettings(void);
    virtual void setOn(bool);//Will switch on/off
protected:
    void initializeGL();
    void paintGL();
    void resizeGL( int w, int h );
    virtual void scopeEvent(float *left, float *right, int bands);
    virtual void mouseReleaseEvent(QMouseEvent *);
private:
    bool isOn, myOn;
    bool mBarSizeIsStatic;
    int mUserBarWidth, mUserBarHeight, mUserBarAlongX, mUserBarAlongY;
    int mBarWidth, mBarHeight, mHSpace, mVSpace;
    int mBands, mBars;
    int mPadding;
    int *m_pData, *m_pPeak, *m_pPeakHold;
    GLfloat colR1, colG1, colB1;
    GLfloat colR2, colG2, colB2;
    GLfloat colR3, colG3, colB3;
    GLfloat colR4, colG4, colB4;
    bool showPeaks;

    void calculate();
};

#endif
