/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include <stdlib.h>
#include <locale.h>
#include <errno.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <glib/gthread.h>
#include <glib/gstdio.h>

#include "ui.h"
#include "coverfinder.h"

static CFApp *app_init ()
{
	CFApp *app;
	CFConfig *config;
	const gchar *cache_home;

	app = g_new (CFApp, 1);
	config = g_new (CFConfig, 1);

	cache_home = g_get_user_cache_dir ();
	config->cache_dir = g_build_filename (cache_home, "coverfinder", NULL);
	if (!g_file_test (config->cache_dir, G_FILE_TEST_IS_DIR)) {
		if (g_mkdir_with_parents (config->cache_dir, S_IRWXU) == -1) {
			g_fprintf (stderr, "Can't create cache directory: %s.\n", g_strerror (errno));
			exit (EXIT_FAILURE);
		}
	}

	app->config = config;
	return app;
}

int main (int argc, char **argv)
{
	CFApp *app;

	setlocale (LC_ALL, "");
	g_thread_init (NULL);
	gdk_threads_init ();
	gtk_init (&argc, &argv);
	app = app_init ();
	app->gui = ui_init (app);
	gtk_main ();
	exit (EXIT_SUCCESS);
}
