/*
 * CoverFinder - Find and download cover images from Amazon 
 * Copyright (C) 2007 - Sven Salzwedel
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#define SRESULT_TYPE_CDDA "Audio CD"
#define SRESULT_TYPE_DVD "DVD"
#define SRESULT_TYPE_OTHER ""

enum {
	SPROVIDER_AMAZON
};

typedef struct {
	gchar *title;
	gchar *artist;
	const gchar *type;
	gchar *image_url;
	gchar *image_file;
	gchar *markup;
} SResult;

typedef struct {
	gchar *description;
	gint type;
	void *data;
} SProvider;

gint search_results_cmp (const SResult *, const SResult *);
gchar *search_result_get_markup (SResult *);
SResult *search_result_new (void);
void search_result_free (SResult *);
