#!/bin/bash

clear
echo "DVDShrink installer v1.1"

# run this script as root

if [ $UID -ne 0 ]
then
   echo
   echo "You have to be root to run this installer."
   echo
   exit
fi

function testistring {
   INP=`echo $1 | tr 'a-z' 'A-Z'`
   TST=`echo $2 | tr 'a-z' 'A-Z'`
   VAR=${INP%%$TST*}
   if [ "$VAR" = "$INP" ]; then echo 0; else echo 1; fi 
}

echo
echo "Checking for dependencies"
BAD=0
which tccat > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   Transcode not installed or utilities not executable"; ((BAD++)); fi
which mplex > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   MJpegtools not installed or utilities not executable"; ((BAD++)); fi
which subtitle2pgm > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   SubtitleRipper not installed or utilities not executable"; ((BAD++)); fi
which mkisofs > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   Mkisofs not installed or utilities not executable"; ((BAD++)); fi
which dvdauthor > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   Dvdauthor not installed or utilities not executable"; ((BAD++)); fi
which growisofs > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   DVD+RW-tools not installed or utilities not executable"; ((BAD++)); fi
which gocr > /dev/null 2>&1
if [ $? -ne 0 ]; then echo "   GOcr is not installed or utilities not executable"; ((BAD++)); fi

if [ $BAD -gt 0 ]; then
   echo
   echo "   One or more of the utilities that DVDShrink requires are not installed or"
   echo -n "   are not executable. Continue the installation? (y/n)   "
   read YN
   if [ -z $YN ]; then exit; fi
   if [ `testistring $YN 'n'` -eq 1 ]; then exit; fi 
fi

echo
echo "Installing DVDShrink..."   
echo "--------------------------------------------"

echo
echo "Removing old version from /usr/local/bin if it exists"
for FILE in dvdsfunctions dvdshrink copydvd xdvdshrink.pl; do
   if [ -f /usr/local/bin/$FILE ]; then
      rm -f /usr/local/bin/$FILE
   fi
done

echo
echo "Creating application directories if needed"
for DIR in doc applications; do
   if [ ! -d /usr/share/$DIR/dvdshrink ]; then
      mkdir -p /usr/share/$DIR/dvdshrink
   fi
done

echo
echo "Installing files"
cp usr/bin/* /usr/bin
cp -R usr/share/* /usr/share

echo
echo "Removing rc files if they exist"
for DIR in `ls /home`; do
   if [ -f /home/$DIR/.dvdshrinkrc ]; then
      echo "   Found rc file in /home/$DIR... removing"
      rm -f /home/$DIR/.dvdshrinkrc
   fi
done

echo
echo -n "Checking for perl-gtk2   "
VAR=`find /usr -name Gtk2.pm 2> /dev/null`
if [ -z $VAR ]; then
   echo "Not found!"
   echo "   perl-gtk2 not found..."
   echo "   If you want the graphical 'front-end' to the scripts you'll need"
   echo "   to install perl-gtk2."
   echo
else
   echo "Found!"
fi

echo
echo "DVDShrink must be reconfigured the next time it's run"
echo


