#!/bin/bash

# Script:  batchrip.sh
# Version: 2.6.1
# Date:    May 04, 2007
# Author:  Rick Saunders <ozzzy1@gmail.com>"

# This is a small script that will allow you call the 'dvdshrink'
# script to 'batch' rip episodic DVD's (like TV shows). It uses
# the same functions and configuration file as 'dvdshrink'.

EVERSION="2.6.1"
EDATE="11 Dec, 2006"

PIDFILE=~/.batchrip.pid
echo $$ > $PIDFILE

PROGRAM="BATCHRIP"

DIRNAME=${0%/*} && FUNCFILE=$DIRNAME/dvdsfunctions
if [ -e $FUNCFILE -a -r $FUNCFILE ]; then
   . $FUNCFILE
else
   echo "$FUNCFILE does not exist or is not readable! Make sure the file"
   echo "is in the same directory as the script with permissions of at"
   echo "least 666 and rerun the script!"
   echo -en "\nHit any key to exit!     "
   read
   rm -f $PIDFILE
   exit
fi

readbatchdefaults
readconfig
ebanner

# Parse out the options
#---------------------------------------------------
while [ "$1" != "" ]; do
  case $1 in
     -a | --audiostream)         shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "audio stream" "-a"
                                 else 
                                    AUDIOSTREAM=$1
                                 fi;;
                                 
     -B | --burndvds)            BURNDVDS=1;;
     
     -b | --basedir)             shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "base directory" "-b"
                                 else 
                                    BASEDIR=$1
                                 fi;;

     -e | --episodes)            shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "episodes per DVD" "-e"
                                 else 
                                    MAXEPISODES=$1
                                 fi;;
                                 
     -F | --forceburn)           FORCEBURN=1;;

     -d | --builddvd)            AUTHORDVD=1;;
     
     -i | --interactive)         INTERACTIVE=1;;

     -I | --isoonly)             ISOONLY=1;;
          
     -k | --shrinkfactor)        shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "shrink factor" "-k"
                                 else 
                                    SHRINKFAC=$1
                                 fi;;

     -m | --createmenu)          MENU=1;;

     -M | --nomenu)              MENU=0;;
                                      
     -l | --lasttitle)           shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "last title to rip" "-l"
                                 else 
                                    LASTTITLE=$1
                                 fi;;
                                 
     -L | --deletelogs)          DELETELOGS=1;;
                                 
     -n | --showname)            shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "show name" "-n"
                                 else 
                                    TVNAME=$1
                                 fi;;

     -o | --isodir)              shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "ISO directory" "-o"
                                 else 
                                    ISODIR=$1
                                 fi;;

     -O | --saveiso)             SAVEISO=1;;           

     -N | --noremovefiles)       RMFILES=0;;
     
     -r | --riplist)             shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "riplist" "-r"
                                 else 
                                    RIPLIST=$1
                                 fi;;

     -R | --removefiles)         RMFILES=1;;                                           
                                 
     -s| --starttile)            shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "shrink factor" "-k"
                                 else 
                                    FRSTTITLE=$1;
                                 fi;;

     -u | --substream)           shift
                                 testarg $1
                                 if (($BADARG)); then 
                                    argerror "subtitle stream" "-u"
                                 else 
                                    SUBSTREAM=$1
                                 fi;;

     -x | --buildxml)            BUILDXML=1;;
                                 
     -h | --help)                busage;;
     
     --restart)                  RESTART=1;;

     --postprocess)              POSTPROCESS=1;;
          
     *)                          busage;;
  esac
  shift
done

# Ask the questions needed for the script
#--------------------------------------------
if (($INTERACTIVE)); then
   echo -n "Enter the TV show name with no spaces (SHOW):           "
   read TVNAME
   if [ -z $TVNAME ]; then TVNAME="SHOW"; fi
   echo -n "Do you wish to enter a specific list of titles? (y/n)   "
   read YN
   case $YN in
      y|Y)  
            echo -n "Enter a comma seperated list of titles                  "
            read RIPLIST;;
      *)
            echo -n "Enter the first title to rip (1):                       "
            read FRSTTITLE
            if [ -z $FRSTTITLE ]; then FRSTTITLE=1; fi
            echo -n "Enter the last title. Must be greater than $FRSTTITLE (8):       "
            read LASTTITLE
            if [ -z $LASTTITLE ]; then LASTTITLE=8; fi
            ;;
   esac
   echo -n "Enter the audio stream to rip (0)                       "
   read AUDIOSTREAM
   if [ -z $AUDIOSTREAM ]; then AUDIOSTREAM=0; fi
   echo -n "Enter the subtitle stream to rip (none)                 "
   read SUBSTREAM
   if [ -z $SUBSTREAM ]; then SUBSTREAM=99; fi
   echo -n "Enter a shrink factor between 1 and 2 (1.5):            "
   read SHRINKFAC
   if [ -z $SHRINKFAC ]; then SHRINKFAC=""; fi
   echo -n "Enter the number of episodes per new DVD: (3)           "
   read MAXEPISODES
   if [ -z $MAXEPISODES ]; then MAXEPISODES=3; fi
fi

# Set the needed values if 'restart' is called
#--------------------------------------------
if (($RESTART || $POSTPROCESS)); then
   if [ -f /tmp/batchrip.fail ]; then
      . /tmp/batchrip.fail
      if (($RESTART));     then echo "You have called for a 'RESTART'\n\n"; fi
      if (($POSTPROCESS)); then echo "You have requested POSTPROCESSING only!\n\n"; fi
      echo -e "\n   The /tmp/batchrip.fail file is being moved to your home directory."
      echo "   When you are finished you can delete it! If there are any further"
      echo -e "   errors then a new /tmp/batchrip.fail file will be created!\n"
      mv -f /tmp/batchrip.fail ~/batchrip.fail
   else
      echo "   You have requested either RESTART or POSTPROCESSING but"
      echo "   there is no '/tmp/batchrip.fail' file for the application"
      echo -e "   to read it's configuration from!\n"
      echo -n "   Hit any key to exit          "
      read
      rm -f $PIDFILE
      exit
   fi
fi

# Set the build directory name
#--------------------------------------------
BUILDDIR=$BASEDIR/$TVNAME     # The DVD build directory

# If we're doing the 'whole smash' then keep going. If we're
# just post-processing a series of successful rips then we
# can ignore all of this
#--------------------------------------------
if ((! $POSTPROCESS)); then

   # Create the build directory if needed

   if [ ! -d $BUILDDIR ]; then
      mkdir -p $BUILDDIR
   fi

   # Prompt for the DVD as 'DVDShrink' won't

   echo
   echo "Place your source DVD in the read device"
   if (($MULTIDRIVE)); then
      echo "Place your blank DVD in the write device"
   fi
   echo
   echo -n "Hit any key to begin ripping titles...   "
   read JUNK

   INFOFILE=/tmp/dvdinfo
   tcprobe -i $RDEVICE -T 1 -H 200 > $INFOFILE 2>&1
   DINFO=`cat $INFOFILE`
   gettvmode

   # Now build the rip list (if needed)

   if [ $FRSTTITLE -eq $LASTTITLE ]; then RIPLIST=$FRSTTITLE
   else
      TESTLIST=${RIPLIST%%,*}
      if ! (($TESTLIST)); then
         for a in `seq $FRSTTITLE $LASTTITLE`; do
            if [ $a -eq $FRSTTITLE ]; then RIPLIST=$FRSTTITLE" "
            elif [ $a -eq $LASTTITLE ]; then RIPLIST=$RIPLIST"$LASTTITLE"
            else RIPLIST=$RIPLIST"$a "; fi
         done
      else
         RIPLIST=${RIPLIST//\,/ }
      fi
   fi

   FRIPLIST=""
   FRIPCOUNT=0
   ISERROR=0
   
   # Rip, shrink, multiplex and store each title

   for a in $RIPLIST; do
      PROJNAME="$TVNAME."`date +%H%M`".EPISODE.$a"
      PROJDIR=$BASEDIR/$PROJNAME
      OPTIONS=" -n -t $a -m -p $PROJNAME -a $AUDIOSTREAM -e $MAXEPISODES"
      if [ $SUBSTREAM -ne 99 ]; then OPTIONS=$OPTIONS" -u $SUBSTREAM"; fi
      if [ ! -z $SHRINKFAC ]; then OPTIONS=$OPTIONS" -k $SHRINKFAC"; fi
      dvdshrink $OPTIONS
      DRET=$?
      if  ! (($DRET)); then
         mv $PROJDIR/$PROJNAME.mpg $BUILDDIR
         mv $PROJDIR/$PROJNAME.chap $BUILDDIR
         rm -rf $PROJDIR/*
         rmdir $PROJDIR
      else
         if ! (($FRIPCOUNT)); then
            FRIPLIST=$a
         else
            FRIPLIST="$FRIPLIST,$a"
         fi
         echo "TVNAME=$TVNAME"           >  /tmp/batchrip.fail
         echo "TVMODE=$TVMODE"           >> /tmp/batchrip.fail
         echo "AUDIOSTREAM=$AUDIOSTREAM" >> /tmp/batchrip.fail
         echo "SUBSTREAM=$SUBSTREAM"     >> /tmp/batchrip.fail
         echo "RIPLIST=$FRIPLIST"        >> /tmp/batchrip.fail
         echo "SHRINKFAC=$SHRINKFAC"     >> /tmp/batchrip.fail
         echo "EPISODES=$EPISODES"       >> /tmp/batchrip.fail
         echo "AUTHORDVD=$AUTHORDVD"     >> /tmp/batchrip.fail
         echo "BUILDXML=$BUILDXML"       >> /tmp/batchrip.fail
         echo "BURNDVDS=$BURNDVDS"       >> /tmp/batchrip.fail
         echo "FORCEBURN=$FORCEBURN"     >> /tmp/batchrip.fail
         echo "ISOONLY=$ISONLY"          >> /tmp/batchrip.fail
         echo "SAVEISO=$SAVEISO"         >> /tmp/batchrip.fail
         echo "DELETELOGS=$DELETELOGS"   >> /tmp/batchrip.fail
 
         # Set all the post-processing to 'no' for this batch

         AUTHORDVD=0
         BURNDVDS=0
         FORCEBURN=0
         ISOONLY=0
         SAVEISO=0

         ((FRIPCOUNT++))
         ((ISERROR++))
      fi
   done

   if (($ISERROR)); then
      ERTITLE=${FRIPLIST//,/ }
      clear
      ebanner
      echo -en "   \033[1mBATCH ERRORS REPORTED\033[0m\n"
      echo "   There were $ISERROR failures in the rip of this multi-"
      echo "   episode DVD. The titles numbered $ERTITLE were not ripped."
      echo "   A 'fail' file has been written. You may now check the"
      echo "   source DVD; pehaps trying to singly rip the titles listed"
      echo "   above. If you can fix the problem re-start 'xdvdshrink'"
      echo "   and click the 'Restart' button in the TV Show/Episode mode"
      echo "   to try to re-process the failed rips."
      echo
      echo "   See the episode logs in your home directory!"
      echo
      echo -n "   Hit any key to exit xdvdshrink             "
      read
      rm -f $PIDFILE
      exit
   fi
fi

# Tell us what we're doing post rip
#--------------------------------------------
clear
echo -e "_______________________________________________\n"
echo -e "   \033[1mOzzzy's Batch DVD Ripper\033[0m"
echo "   Post processing..."
echo "_______________________________________________"
echo

# Build the XML files and author if requested
#---------------------------------------------------
if (($BUILDXML)); then
   BuildXML
   if (($AUTHORDVD)); then
      AuthorUsingXML
      if (($ISOONLY)); then 
         CreateISOe
         echo -e "\n   \033[1mYour ISO has been saved in $ISODIR\033[0m\n"
      else
         if (($BURNDVDS || $FORCEBURN)); then 
            BurnDVDs
         else
            echo -e "\n   \033[1mYour DVD(s) are ready to test/burn in $BUILDDIR/DVD.(x)\033[0m\n"
         fi
      fi
   else
      echo -e "\n   \033[1mYour XML files and MPEGs are ready in $BUILDDIR!\033[0m\n"
   fi
else
   echo -e "\n   \033[1mYour MPEG2 and chapter files are ready in $BUILDDIR!\033[0m\n"
fi
CleanUpFiles
echo -e "\n\033[1mThank you for using OzWare.\033[0m\n"
if (($GUI)); then 
   echo "Hit any key to exit!"
   read
fi
rm -f $PIDFILE

