#ifdef BENCHMARK

#warning Benchmark code on!
static unsigned cyc_hi = 0;
static unsigned cyc_lo = 0; 

void access_counter(unsigned *hi, unsigned *lo)
{
  /* Get cycle counter */
  asm("pushl %%ebx; cpuid; rdtsc; movl %%edx,%0; movl %%eax,%1; popl %%ebx;"
      : "=r" (*hi), "=r" (*lo)
      : /* No input */
      : "%ecx","%edx", "%eax");
}

double get_counter()
{
  unsigned ncyc_hi, ncyc_lo;
  unsigned hi, lo, borrow;

  /* Get cycle counter */
  access_counter(&ncyc_hi, &ncyc_lo);

  /* Do double precision subtraction */
  lo = ncyc_lo - cyc_lo;
  borrow = lo > ncyc_lo;
  hi = ncyc_hi - cyc_hi - borrow;

  return (double) hi * (1 << 30) * 4 + lo;
}

void start_counter()
{
  /* Get current value of cycle counter */
  access_counter(&cyc_hi, &cyc_lo);
}
#endif //BENCHMARK

