/*
 *   PCM time-domain equalizer
 *
 *   Copyright (C) 2002-2006  Felipe Rivera <liebremx at users.sourceforge.net>
 *
 *   19.08.2002 Initial release for XMMS
 *
 * 
 *   added skin support, switchable amplifying, 2003 Simone Karin Lehmann
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Id: configuration.h,v 1.6 2006/01/15 00:26:32 liebremx Exp $
 */

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

typedef struct
{
	gint band_num;
	gboolean use_xmms_original_freqs,
			 use_independent_channels;
	gint x, y;
	gboolean equalizer_autoload, equalizer_active, 
			lock_sliders;
	gfloat equalizer_preamp[EQ_CHANNELS],
			equalizer_bands[EQ_MAX_BANDS][EQ_CHANNELS];
	gchar *eqpreset_default_file, *eqpreset_extension;
	gboolean extra_filtering;
	gboolean shaded;
	gboolean gui_visible;
	gboolean auto_volume_down;
	gint auto_volume_down_ms;
	gchar *skin;
}
EQConfig;

void eq_read_config(void);
void eq_write_config(void);
void eq_configuration_window (void);

extern EQConfig eqcfg;
extern gboolean eq_has_been_initialized;
#endif
