/*
 *   PCM time-domain equalizer
 *
 *   Copyright (C) 2002  Felipe Rivera <liebremx at users.sourceforge.net>
 *
 *   19.08.2002 Initial release for XMMS
 *
 *   
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   $Id: eq.h,v 1.6 2006/01/15 00:16:08 liebremx Exp $
 */
#ifndef EQ_H
#define EQ_H

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <glib.h>
#include <pthread.h>
#include <string.h>

/* XMMS public headers */
#include <xmms/configfile.h>
#include <xmms/plugin.h>
#include <xmms/util.h>
/* XMMS private headers */
#include "dock.h"
#include "widget.h"
#include "vis.h"
#include "main.h"
#include "util.h"
#include "playlist.h"

/* Max bands supported by the code
 FIXME: 31 bands processing IS HARD ON THE PROCESSOR
            On a PIII@900Mhz I got ~45% of CPU usage
            Have to improve the filter implementation
            Got it down to ~20% for 31 Bands
            Still MMX/3DNow!/SSE whatever, can bring it down */
#define EQ_MAX_BANDS 32
/* Number of channels (Stereo) */
#define EQ_CHANNELS 2

#define EQ_LEFT 0
#define EQ_RIGHT 1

#include "configuration.h"
#include "gui.h"
#include "equalizer.h"
#include "eq_graph.h"
#include "eq_slider.h"
#include "eqpbutton.h"
#include "eqtbutton.h"
#include "eqhslider.h"
#include "iir.h"

typedef double sample_t;
typedef sample_t level_t;

void set_eq_value(float value, gint index, gint chn);
int mod_samples(gpointer * d, gint length, AFormat afmt, gint srate, gint nch);
void onswitch(gboolean onstatus);

#endif
