/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "eq_graph.h"

void EQeqgraph_draw(Widget * w)
{
	EQEqGraph *eg = (EQEqGraph *) w;
	GdkPixmap *obj;
	GdkColor col;
	guint32 cols[19];
	gint i, y, ymin, ymax, py = 0;
	gfloat x10[] = {0, 11, 23, 35, 47, 59, 71, 83, 97, 109};
	gfloat x15[] = {0, 7.26*1, 7.26*2, 7.26*3, 7.26*4, 7.26*5, 7.26*6, 7.26*7, 7.26*8, 7.26*9, 7.26*10, 7.26*11, 7.26*12, 7.26*13, 109 };
 // by simone. each step is 109 / 24 cause there are 24 steps in 25 bands. not 109/ 25 like the original sources
 	gfloat x25[] = {0, 4.54*1, 4.54*2, 4.54*3, 4.54*4, 4.54*5, 4.54*6, 4.54*7, 4.54*8, 4.54*9, 4.54*10, 4.54*11, 4.54*12, 4.54*13, 4.54*14,
 					4.54*15, 4.54*16, 4.54*17, 4.54*18, 4.54*19, 4.54*20, 4.54*21, 4.54*22, 4.54*23, 109};
	gfloat x31[] = {0, 3.51*1, 3.51*2, 3.51*3, 3.51*4, 3.51*5, 3.51*6, 3.51*7, 3.51*8, 3.51*9, 3.51*10, 3.51*11, 3.51*12, 3.51*13, 3.51*14,
					3.51*15, 3.51*16, 3.51*17, 3.51*18, 3.51*19, 3.51*20, 3.51*21, 3.51*22, 3.51*23, 3.51*24, 3.51*25, 3.51*26, 3.51*27, 3.51*28,
					3.51*29, 109};

	float *x, yf[EQ_MAX_BANDS], bands[EQ_MAX_BANDS];
	GdkImage *img;

	/*
	 * This avoids the init_spline() function to be inlined.
	 * Inlining the function caused troubles when compiling with
	 * `-O' (at least on FreeBSD).
	 */
	void (*__init_spline)(gfloat *, gfloat *, gint, gfloat *) =
	    init_spline;

	if (eqcfg.band_num == 15)
		x = x15;
 	else if (eqcfg.band_num == 25)
 		x = x25;
	else if (eqcfg.band_num == 31)
		x = x31;
	else
		x = x10;

	obj = eg->eg_widget.parent;

	gdk_draw_pixmap(obj, eg->eg_widget.gc, EQpixmap,
			 0, 178, eg->eg_widget.x, eg->eg_widget.y,
			 eg->eg_widget.width, eg->eg_widget.height);
	gdk_draw_pixmap(obj, eg->eg_widget.gc, EQpixmap,
			 0, 198, eg->eg_widget.x,
			 eg->eg_widget.y + 9 + ((eqcfg.equalizer_preamp[eg->chn] * 9) / 20),
			 eg->eg_widget.width, 1);

	img = gdk_image_get(EQpixmap, 115, 178, 1, 19);
	
	for (i = 0; i < 19; i++)
		cols[i] = gdk_image_get_pixel(img, 0, i);

	gdk_image_destroy(img);

	for (i=0; i<eqcfg.band_num; i++)
		bands[i] = *eg->bands[i];

	__init_spline(x, bands, eqcfg.band_num, yf);
	for (i = 0; i < 109; i++)
	{
		y = 9 - (gint) ((eval_spline(x, bands, yf, eqcfg.band_num, i) * 9.0) / 20.0);
		if (y < 0)
			y = 0;
		if (y > 18)
			y = 18;
		if (!i)
			py = y;
		if (y < py)
		{
			ymin = y;
			ymax = py;
		}
		else
		{
			ymin = py;
			ymax = y;
		}
		py = y;
		for (y = ymin; y <= ymax; y++)
		{
			col.pixel = cols[y];
			gdk_gc_set_foreground(eg->eg_widget.gc, &col);
			gdk_draw_point(obj, eg->eg_widget.gc, eg->eg_widget.x + i + 2, eg->eg_widget.y + y);
		}
	}
}

EQEqGraph *EQcreate_eqgraph(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x, gint y, float bands[][EQ_CHANNELS], gint chn)
{
	EQEqGraph *eg;
	gint i;

	eg = (EQEqGraph *) g_malloc0(sizeof (EQEqGraph));
	eg->eg_widget.parent = parent;
	eg->eg_widget.gc = gc;
	eg->eg_widget.x = x;
	eg->eg_widget.y = y;
	eg->eg_widget.width = 113;
	eg->eg_widget.height = 19;
	eg->eg_widget.visible = TRUE;
	eg->eg_widget.draw = EQeqgraph_draw;
	eg->chn = chn;
	for (i=0; i<eqcfg.band_num; i++)
		eg->bands[i] = &bands[i][chn];
	add_widget(wlist, eg);
	return eg;
}
