/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "eq.h"
#include "widget.h"
#include "eq_slider.h"
#include "equalizer.h"

static const char *band_names31[] =
{
	"PREAMP", "20", "25", "31.5", "40" , "50",
	"63", "80", "100", "125", "160", 
	"200", "250", "315", "400", "500",
	"630", "800", "1k", "1.25k", "1.6k", 
	"2k", "2.5k", "3.15k", "4k", "5k", 
	"6.3k", "8k", "10k", "12.5k", "16k", "20k"
};

static const char *band_names25[] =
{
	"PREAMP", "25", "31.5", "40" , "50",
	"80", "100", "125", "160",
	"250", "315", "400", "500",
	"800", "1k", "1.25k", "1.6k",
	"2.5k", "3.15k", "4k", "5k",
	"8k", "10k", "12.5k", "16k", "20k"
};

static const char *band_names15[] =
{
	"PREAMP", "25", "40", "63", "100", "160", 
	"250", "400", "630", "1k", "1.6k", 
	"2.5k", "4k", "6.3k", "10k", "16k" 
};
static const char *band_names10[] =
{
	"PREAMP", "31", "62", "125", "250", "500", 
	"1k", "2k", "4k", "8k", "16k"
};
static const char *band_names_original10[] =
{
	"PREAMP", "60", "170", "310", "600", "1k", 
	"3k", "6k", "12k", "14k", "16k"
};

static char *names[32];

void EQeqslider_set_position(EQEqSlider * es, gfloat pos)
{
	es->es_position = 25 - (int) ((pos * 25.0) / 20.0);
	if (es->es_position < 0)
		es->es_position = 0;
	if (es->es_position > 50)
		es->es_position = 50;
	if (es->es_position >= 24 && es->es_position <= 26)
		es->es_position = 25;

	draw_widget(es);
}

gfloat EQeqslider_get_position(EQEqSlider * es)
{
	return 20.0 - (((gfloat) es->es_position * 20.0) / 25.0);
}

void EQeqslider_draw(Widget * w)
{
	EQEqSlider *es = (EQEqSlider *) w;
	GdkPixmap *obj;
	GdkPixmap *src;
	gint frame;

	src = EQpixmap;
	obj = es->es_widget.parent;

	frame = 27 - ((es->es_position * 27) / 50);

	if (frame < 14)
		gdk_draw_pixmap(obj, es->es_widget.gc, src, (frame * 15) + 13, 48, es->es_widget.x, es->es_widget.y, es->es_widget.width, es->es_widget.height);
	else
		gdk_draw_pixmap(obj, es->es_widget.gc, src, ((frame - 14) * 15) + 13, 113, es->es_widget.x, es->es_widget.y, es->es_widget.width, es->es_widget.height);
	if (es->es_isdragging)
		gdk_draw_pixmap(obj, es->es_widget.gc, src, 0, 60, es->es_widget.x + 1, es->es_widget.y + es->es_position, 11, 11);
	else
		gdk_draw_pixmap(obj, es->es_widget.gc, src, 0, 48, es->es_widget.x + 1, es->es_widget.y + es->es_position, 11, 11);

}

void EQeqslider_set_names()
{
	/* The +1 in the size is because we include the
	 * "preamp" string in the beginning of names
	 */
	if (eqcfg.band_num == 31)
		memcpy(names, band_names31, sizeof(char *)*(eqcfg.band_num+1));
 	else if (eqcfg.band_num == 25)
 		memcpy(names, band_names25, sizeof(char *)*(eqcfg.band_num+1));
	else if (eqcfg.band_num == 15)
		memcpy(names, band_names15, sizeof(char *)*(eqcfg.band_num+1));
	else if (eqcfg.band_num == 10 && eqcfg.use_xmms_original_freqs)
		memcpy(names, band_names_original10, sizeof(char *)*(eqcfg.band_num+1));
	else
		memcpy(names, band_names10, sizeof(char *)*(eqcfg.band_num+1));
}

void EQeqslider_set_mainwin_text(EQEqSlider * es)
{

	gchar *tmp;
	gfloat db;

	db = EQeqslider_get_position(es) / 20 * 12;
	/* Show the band name in XMMS's main window */
	tmp = g_strdup_printf("EQ: %s%s: %+.1f DB", names[es->index+1],
			(es->index == -1) ? "" : "HZ",
			db);
	mainwin_lock_info_text(tmp);
	g_free(tmp);
}

void EQeqslider_button_press_cb(GtkWidget * w, GdkEventButton * event, gpointer data)
{
	EQEqSlider *es = (EQEqSlider *) data;
	gint y;

	if (inside_widget(event->x, event->y, &es->es_widget))
	{
		if (event->button == 1)
		{
			y = event->y - es->es_widget.y;
			es->es_isdragging = TRUE;
			if (y >= es->es_position && y < es->es_position + 11)
				es->es_drag_y = y - es->es_position;
			else
			{
				es->es_position = y - 5;
				es->es_drag_y = 5;
				if (es->es_position < 0)
					es->es_position = 0;
				if (es->es_position > 50)
					es->es_position = 50;
				if (es->es_position >= 24 && es->es_position <= 26)
					es->es_position = 25;
				EQeqslider_set_mainwin_text(es);
				EQequalizer_eq_changed(es->index, es->chn);
			}
			draw_widget(es);
		}
		if (event->button == 4)
		{
			es->es_position -= 2;
			if (es->es_position < 0)
				es->es_position = 0;
			EQequalizer_eq_changed(es->index, es->chn);
			draw_widget(es);
		}
		if (event->button == 5)
		{
			es->es_position += 2;
			if (es->es_position > 50)
				es->es_position = 50;
			EQequalizer_eq_changed(es->index, es->chn);
			draw_widget(es);
		}
	}
}

void EQeqslider_motion_cb(GtkWidget * w, GdkEventMotion * event, gpointer data)
{
	EQEqSlider *es = (EQEqSlider *) data;
	gint y;

	y = event->y - es->es_widget.y;
	if (es->es_isdragging)
	{
		es->es_position = y - es->es_drag_y;
		if (es->es_position < 0)
			es->es_position = 0;
		if (es->es_position > 50)
			es->es_position = 50;
		if (es->es_position >= 24 && es->es_position <= 26)
			es->es_position = 25;
		EQequalizer_eq_changed(es->index, es->chn);
		EQeqslider_set_mainwin_text(es);
		draw_widget(es);
	}
}

void EQeqslider_button_release_cb(GtkWidget * w, GdkEventButton * event, gpointer data)
{
	EQEqSlider *es = (EQEqSlider *) data;

	if (es->es_isdragging)
	{
		es->es_isdragging = FALSE;
		mainwin_release_info_text();
		draw_widget(es);
	}
}

EQEqSlider *EQcreate_eqslider(GList ** wlist, GdkPixmap * parent, GdkGC * gc, gint x, gint y, gint index, gint chn)
{
	EQEqSlider *es;

	es = (EQEqSlider *) g_malloc0(sizeof (EQEqSlider));
	es->es_widget.parent = parent;
	es->es_widget.gc = gc;
	es->es_widget.x = x;
	es->es_widget.y = y;
	es->es_widget.width = 14;
	es->es_widget.height = 63;
	es->es_widget.visible = TRUE;
	es->es_widget.button_press_cb = GTK_SIGNAL_FUNC(EQeqslider_button_press_cb);
	es->es_widget.button_release_cb = GTK_SIGNAL_FUNC(EQeqslider_button_release_cb);
	es->es_widget.motion_cb = GTK_SIGNAL_FUNC(EQeqslider_motion_cb);
	es->es_widget.draw = EQeqslider_draw;
	es->index = index;
	es->chn = chn;
	add_widget(wlist, es);
	return es;
}
